import { _ as h, d as u, X as g, B as k } from "./main-CkFK4rnR.js";
import { resolveComponent as l, createBlock as w, openBlock as a, withCtx as d, createElementVNode as p, createElementBlock as f, Fragment as _, renderList as D, normalizeClass as B, createVNode as C, toDisplayString as X } from "vue";
const M = {
  name: "displayer-actions",
  components: {
    BaseDisplayer: k,
    XWikiIcon: g
  },
  // Add the displayerMixin to get access to all the displayers methods and computed properties inside this component
  mixins: [u],
  computed: {
    actions() {
      return (this.config.actions || this.data.meta.actions).filter((i) => this.logic.isActionAllowed(i, this.entry)).map((i) => this.logic.getActionDescriptor(i));
    }
  },
  methods: {
    async handleClick(i, o) {
      const { async: e } = o;
      if (e && (i.preventDefault(), await new Promise((t) => {
        e.confirmationMessage ? new XWiki.widgets.ConfirmationBox({
          onYes: () => t(!0),
          onNo: () => t(!1)
        }, {
          confirmationText: e.confirmationMessage
        }) : t(!0);
      }))) {
        const t = new XWiki.widgets.Notification(e.loadingMessage, "inprogress"), r = this.sanitizeUrl(this.entry[o.urlProperty]), n = {
          method: e.httpMethod
        };
        e.body && (n.body = e.body), e.headers && (n.headers = e.headers), (await fetch(r, n)).ok ? (t.replace(new XWiki.widgets.Notification(e.successMessage, "done")), this.logic.updateEntries()) : t.replace(new XWiki.widgets.Notification(e.failureMessage, "error"));
      }
    }
  }
}, W = { class: "actions-container" }, N = ["title", "href", "onClick"], x = { class: "action-name" };
function A(i, o, e, m, t, r) {
  const n = l("XWikiIcon"), c = l("BaseDisplayer");
  return a(), w(c, {
    class: "displayer-actions",
    "view-only": "",
    "property-id": i.propertyId,
    entry: i.entry,
    "is-empty": !1,
    "intercept-touch": !1
  }, {
    viewer: d(() => [
      p("div", W, [
        (a(!0), f(_, null, D(r.actions, (s) => (a(), f("a", {
          key: s.id,
          class: B("action action_" + s.id),
          title: s.description,
          href: i.sanitizeUrl(i.entry[s.urlProperty]) || "#",
          onClick: (y) => r.handleClick(y, s)
        }, [
          C(n, {
            iconDescriptor: s.icon,
            class: "action-icon"
          }, null, 8, ["iconDescriptor"]),
          p("span", x, X(s.name), 1)
        ], 10, N))), 128))
      ])
    ]),
    editor: d(() => o[0] || (o[0] = [])),
    _: 1
  }, 8, ["property-id", "entry"]);
}
const v = /* @__PURE__ */ h(M, [["render", A]]);
export {
  v as default
};
//# sourceMappingURL=DisplayerActions-U7lOGMTH.js.map
