/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.livedata.internal.rest;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.livedata.LiveDataPropertyDescriptor;
import org.xwiki.livedata.LiveDataQuery;
import org.xwiki.livedata.LiveDataSource;
import org.xwiki.livedata.internal.rest.AbstractLiveDataResource;
import org.xwiki.livedata.rest.LiveDataPropertiesResource;
import org.xwiki.livedata.rest.LiveDataPropertyResource;
import org.xwiki.livedata.rest.LiveDataSourceResource;
import org.xwiki.livedata.rest.model.jaxb.Properties;
import org.xwiki.livedata.rest.model.jaxb.PropertyDescriptor;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Link;

@Component
@Named(value="org.xwiki.livedata.internal.rest.DefaultLiveDataPropertiesResource")
public class DefaultLiveDataPropertiesResource
extends AbstractLiveDataResource
implements LiveDataPropertiesResource {
    @Override
    public Properties getProperties(String sourceId, String namespace) throws Exception {
        LiveDataQuery.Source querySource = this.getLiveDataQuerySource(sourceId);
        Optional source = this.liveDataSourceManager.get(querySource, namespace);
        if (source.isPresent()) {
            return this.createProperties(((LiveDataSource)source.get()).getProperties().get(), querySource, namespace);
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    private Properties createProperties(Collection<LiveDataPropertyDescriptor> propertyDescriptors, LiveDataQuery.Source source, String namespace) {
        Link self = new Link().withRel("self").withHref(this.uriInfo.getAbsolutePath().toString());
        Link parent = this.withNamespaceAndSourceParams(this.createLink("http://www.xwiki.org/rel/parent", LiveDataSourceResource.class, source.getId()), namespace, (Map<String, Object>)source.getParameters());
        List<PropertyDescriptor> properties = propertyDescriptors.stream().map(propertyDescriptor -> this.createPropertyType((LiveDataPropertyDescriptor)propertyDescriptor, source, namespace)).collect(Collectors.toList());
        return (Properties)new Properties().withProperties(properties).withLinks(new Link[]{self, parent});
    }

    @Override
    public Response addProperty(String sourceId, String namespace, PropertyDescriptor propertyDescriptor) throws Exception {
        LiveDataQuery.Source querySource = this.getLiveDataQuerySource(sourceId);
        Optional source = this.liveDataSourceManager.get(querySource, namespace);
        if (source.isPresent()) {
            Optional property;
            if (((LiveDataSource)source.get()).getProperties().save(this.convert(propertyDescriptor)) && (property = ((LiveDataSource)source.get()).getProperties().get(propertyDescriptor.getId())).isPresent()) {
                PropertyDescriptor addedProperty = this.createProperty((LiveDataPropertyDescriptor)property.get(), querySource, namespace);
                URI location = Utils.createURI((URI)this.uriInfo.getBaseUri(), LiveDataPropertyResource.class, (Object[])new Object[]{querySource.getId(), addedProperty.getId()});
                location = this.withNamespaceAndSourceParams(location, namespace, (Map<String, Object>)querySource.getParameters());
                return Response.created((URI)location).entity((Object)addedProperty).build();
            }
            return null;
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }
}

