/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.livedata.internal.rest;

import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.livedata.LiveDataConfiguration;
import org.xwiki.livedata.LiveDataEntryStore;
import org.xwiki.livedata.LiveDataQuery;
import org.xwiki.livedata.LiveDataSource;
import org.xwiki.livedata.internal.rest.AbstractLiveDataResource;
import org.xwiki.livedata.internal.rest.LiveDataResourceContextInitializer;
import org.xwiki.livedata.rest.LiveDataEntryResource;
import org.xwiki.livedata.rest.model.jaxb.Entry;

@Component
@Named(value="org.xwiki.livedata.internal.rest.DefaultLiveDataEntryResource")
public class DefaultLiveDataEntryResource
extends AbstractLiveDataResource
implements LiveDataEntryResource {
    @Inject
    private LiveDataResourceContextInitializer contextInitializer;

    @Override
    public Entry getEntry(String sourceId, String namespace, String entryId) throws Exception {
        LiveDataEntryStore entryStore;
        Optional values;
        this.contextInitializer.initialize(namespace);
        LiveDataQuery.Source querySource = this.getLiveDataQuerySource(sourceId);
        Optional source = this.liveDataSourceManager.get(querySource, namespace);
        if (source.isPresent() && (values = (entryStore = ((LiveDataSource)source.get()).getEntries()).get((Object)entryId)).isPresent()) {
            return this.createEntry((Map)values.get(), entryId, querySource, namespace);
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    @Override
    public Response updateEntry(String sourceId, String namespace, String entryId, Entry entry) throws Exception {
        this.contextInitializer.initialize(namespace);
        LiveDataConfiguration config = this.getLiveDataConfig(sourceId);
        Optional source = this.liveDataSourceManager.get(config.getQuery().getSource(), namespace);
        if (source.isPresent()) {
            String idProperty = config.getMeta().getEntryDescriptor().getIdProperty();
            entry.getValues().put(idProperty, entryId);
            LiveDataEntryStore entryStore = ((LiveDataSource)source.get()).getEntries();
            Optional updatedEntryId = entryStore.save((Map)entry.getValues());
            if (updatedEntryId.isPresent()) {
                Optional values;
                try {
                    values = entryStore.get(updatedEntryId.get());
                }
                catch (UnsupportedOperationException e) {
                    return Response.status((Response.Status)Response.Status.ACCEPTED).build();
                }
                if (values.isPresent()) {
                    Entry updatedEntry = this.createEntry((Map)values.get(), updatedEntryId.get(), config.getQuery().getSource(), namespace);
                    return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)updatedEntry).build();
                }
            }
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    @Override
    public void deleteEntry(String sourceId, String namespace, String entryId) throws Exception {
        Optional removedEntry;
        this.contextInitializer.initialize(namespace);
        LiveDataQuery.Source querySource = this.getLiveDataQuerySource(sourceId);
        Optional source = this.liveDataSourceManager.get(querySource, namespace);
        if (source.isPresent() && (removedEntry = ((LiveDataSource)source.get()).getEntries().remove((Object)entryId)).isPresent()) {
            return;
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }
}

