/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.livedata.internal.macro;

import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.livedata.LiveDataException;
import org.xwiki.livedata.internal.LiveDataRenderer;
import org.xwiki.livedata.internal.LiveDataRendererParameters;
import org.xwiki.livedata.macro.LiveDataMacroParameters;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="liveData")
@Singleton
public class LiveDataMacro
extends AbstractMacro<LiveDataMacroParameters> {
    @Inject
    private LiveDataRenderer liveDataRenderer;

    public LiveDataMacro() {
        super("Live Data", "Display dynamic lists of data.", (ContentDescriptor)new DefaultContentDescriptor("Advanced Live Data configuration (JSON)", false), LiveDataMacroParameters.class);
        this.setDefaultCategories(Set.of("Content"));
    }

    public List<Block> execute(LiveDataMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        try {
            boolean restricted = context.getTransformationContext().isRestricted();
            return List.of(this.liveDataRenderer.execute((LiveDataRendererParameters)parameters, content, restricted));
        }
        catch (LiveDataException e) {
            throw new MacroExecutionException("Failed to render the content of the LiveData macro.", (Throwable)e);
        }
    }

    public boolean supportsInlineMode() {
        return false;
    }

    public boolean isExecutionIsolated(LiveDataMacroParameters parameters, String content) {
        return true;
    }
}

