/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.livedata.internal.livetable;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.StringListProperty;
import com.xpn.xwiki.objects.classes.DateClass;
import com.xpn.xwiki.objects.classes.LevelsClass;
import com.xpn.xwiki.objects.classes.ListClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.livedata.LiveDataConfiguration;
import org.xwiki.livedata.LiveDataException;
import org.xwiki.livedata.LiveDataPropertyDescriptor;
import org.xwiki.livedata.LiveDataPropertyDescriptorStore;
import org.xwiki.livedata.WithParameters;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="liveTable")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class LiveTableLiveDataPropertyStore
extends WithParameters
implements LiveDataPropertyDescriptorStore {
    private static final String EQUALS_OPERATOR = "equals";
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> currentDocumentReferenceResolver;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private ContextualAuthorizationManager authorization;
    @Inject
    @Named(value="liveTable")
    private Provider<LiveDataConfiguration> defaultConfigProvider;
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> localEntityReferenceSerializer;
    @Inject
    private ContextualLocalizationManager localizationManager;

    public Collection<LiveDataPropertyDescriptor> get() throws LiveDataException {
        ArrayList<LiveDataPropertyDescriptor> properties = new ArrayList<LiveDataPropertyDescriptor>();
        properties.addAll(this.getDocumentProperties());
        try {
            properties.addAll(this.getClassProperties());
        }
        catch (Exception e) {
            throw new LiveDataException("Failed to retrieve class properties.", (Throwable)e);
        }
        return properties;
    }

    private Collection<LiveDataPropertyDescriptor> getDocumentProperties() {
        return ((LiveDataConfiguration)this.defaultConfigProvider.get()).getMeta().getPropertyDescriptors();
    }

    private List<LiveDataPropertyDescriptor> getClassProperties() throws Exception {
        Object className = this.getParameters().get("className");
        if (className instanceof String) {
            DocumentReference classReference = this.currentDocumentReferenceResolver.resolve((Object)((String)className), new Object[0]);
            return this.getClassProperties(classReference);
        }
        return Collections.emptyList();
    }

    private List<LiveDataPropertyDescriptor> getClassProperties(DocumentReference classReference) throws Exception {
        if (this.authorization.hasAccess(Right.VIEW, (EntityReference)classReference)) {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            XWikiDocument classDoc = xcontext.getWiki().getDocument(classReference, xcontext);
            return classDoc.getXClass().getEnabledProperties().stream().map(this::getLiveDataPropertyDescriptor).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private String getRightTranslationWithFallback(String right) {
        String result = this.localizationManager.getTranslationPlain("rightsmanager." + right, new Object[0]);
        if (StringUtils.isEmpty((CharSequence)result)) {
            result = right;
        }
        return result;
    }

    private LiveDataPropertyDescriptor getLiveDataPropertyDescriptor(PropertyClass xproperty) {
        String dateFormat;
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        LiveDataPropertyDescriptor descriptor = new LiveDataPropertyDescriptor();
        descriptor.setId(xproperty.getName());
        descriptor.setName(xproperty.getTranslatedPrettyName(xcontext));
        descriptor.setDescription(xproperty.getHint());
        descriptor.setType(xproperty.getClassType());
        if (xproperty instanceof ListClass && ((ListClass)xproperty).isMultiSelect()) {
            descriptor.setSortable(Boolean.valueOf(false));
        }
        descriptor.setDisplayer(new LiveDataPropertyDescriptor.DisplayerDescriptor("xObjectProperty"));
        if (xproperty instanceof ListClass) {
            LiveDataPropertyDescriptor.FilterDescriptor filterList = new LiveDataPropertyDescriptor.FilterDescriptor("list");
            if (xproperty instanceof LevelsClass) {
                filterList.setParameter("options", ((LevelsClass)xproperty).getList(xcontext).stream().map(item -> Map.of("value", item, "label", this.getRightTranslationWithFallback((String)item))).collect(Collectors.toList()));
            } else {
                filterList.setParameter("searchURL", (Object)this.getSearchURL(xproperty));
            }
            if (xproperty.newProperty() instanceof StringListProperty) {
                filterList.addOperator("empty", null);
                filterList.addOperator(EQUALS_OPERATOR, null);
                filterList.setDefaultOperator(EQUALS_OPERATOR);
            }
            descriptor.setFilter(filterList);
        } else if (xproperty instanceof DateClass && !StringUtils.isEmpty((CharSequence)(dateFormat = ((DateClass)xproperty).getDateFormat()))) {
            descriptor.setFilter(new LiveDataPropertyDescriptor.FilterDescriptor("date"));
            descriptor.getFilter().setParameter("dateFormat", (Object)dateFormat);
        }
        return descriptor;
    }

    private String getSearchURL(PropertyClass xproperty) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        DocumentReference xclassReference = xproperty.getObject().getDocumentReference();
        List<String> pathElements = Arrays.asList("rest", "wikis", xclassReference.getWikiReference().getName(), "classes", (String)this.localEntityReferenceSerializer.serialize((EntityReference)xclassReference, new Object[0]), "properties", xproperty.getName(), "values");
        String path = pathElements.stream().map(element -> {
            try {
                return URLEncoder.encode(element, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return element;
            }
        }).collect(Collectors.joining("/"));
        return xcontext.getRequest().getContextPath() + "/" + path + "?fp={encodedQuery}";
    }
}

