/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.livedata.internal.livetable;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.livedata.LiveDataConfiguration;
import org.xwiki.livedata.LiveDataConfigurationResolver;
import org.xwiki.livedata.LiveDataException;
import org.xwiki.livedata.LiveDataMeta;
import org.xwiki.livedata.LiveDataPropertyDescriptor;

@Component
@Named(value="liveTable")
@Singleton
public class DefaultLiveDataConfigurationProvider
implements Provider<LiveDataConfiguration> {
    private static final List<String> USER_DOC_PROPS = Arrays.asList("doc.creator", "doc.author");
    @Inject
    private LiveDataConfigurationResolver<String> stringLiveDataConfigResolver;
    @Inject
    @Named(value="wiki")
    private ConfigurationSource wikiConfig;
    private String defaultConfigJSON;

    public LiveDataConfiguration get() {
        if (this.defaultConfigJSON == null) {
            try {
                InputStream defaultConfigInputStream = this.getClass().getResourceAsStream("/liveTableLiveDataConfiguration.json");
                this.defaultConfigJSON = IOUtils.toString((InputStream)defaultConfigInputStream, (String)"UTF-8");
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read the default live data configuration for the live table source.", e);
            }
        }
        try {
            LiveDataConfiguration defaultConfig = this.stringLiveDataConfigResolver.resolve((Object)this.defaultConfigJSON);
            this.maybeSetDateFormat(defaultConfig.getMeta());
            this.setSearchURLForUserFilter(defaultConfig.getMeta());
            return defaultConfig;
        }
        catch (LiveDataException e) {
            throw new RuntimeException("Failed to parse the default live data configuration for the live table source.", e);
        }
    }

    private void maybeSetDateFormat(LiveDataMeta meta) {
        Optional<LiveDataPropertyDescriptor.FilterDescriptor> dateFilter;
        String dateFormat = (String)this.wikiConfig.getProperty("dateformat");
        if (!StringUtils.isEmpty((CharSequence)dateFormat) && (dateFilter = meta.getFilters().stream().filter(filter -> "date".equals(filter.getId())).findFirst()).isPresent()) {
            dateFilter.get().setParameter("dateFormat", (Object)dateFormat);
        }
    }

    private void setSearchURLForUserFilter(LiveDataMeta meta) {
        meta.getPropertyDescriptors().stream().filter(property -> USER_DOC_PROPS.contains(property.getId())).forEach(this::setSearchURLForUserFilter);
    }

    private void setSearchURLForUserFilter(LiveDataPropertyDescriptor property) {
        if (property.getFilter() == null) {
            property.setFilter(new LiveDataPropertyDescriptor.FilterDescriptor("list"));
        }
        property.getFilter().setParameter("searchURL", (Object)"?xpage=uorgsuggest&uorg=user&input={encodedQuery}&media=json");
    }
}

