/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.livedata.script;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.livedata.LiveData;
import org.xwiki.livedata.LiveDataConfiguration;
import org.xwiki.livedata.LiveDataException;
import org.xwiki.livedata.LiveDataQuery;
import org.xwiki.livedata.LiveDataSource;
import org.xwiki.livedata.LiveDataSourceManager;
import org.xwiki.livedata.internal.LiveDataRenderer;
import org.xwiki.livedata.internal.LiveDataRendererConfiguration;
import org.xwiki.livedata.internal.LiveDataRendererParameters;
import org.xwiki.livedata.internal.script.LiveDataConfigHelper;
import org.xwiki.rendering.block.Block;
import org.xwiki.script.service.ScriptService;
import org.xwiki.script.service.ScriptServiceManager;
import org.xwiki.stability.Unstable;

@Component
@Named(value="liveData")
@Singleton
public class LiveDataScriptService
implements ScriptService {
    public static final String ROLEHINT = "liveData";
    @Inject
    private Logger logger;
    @Inject
    private LiveDataSourceManager sourceManager;
    @Inject
    private LiveDataConfigHelper configHelper;
    @Inject
    private ScriptServiceManager scriptServiceManager;
    @Inject
    private LiveDataRenderer liveDataRenderer;
    @Inject
    private LiveDataRendererConfiguration liveDataRendererConfiguration;

    public LiveData query(Map<String, Object> queryConfig) {
        try {
            LiveDataConfiguration liveDataConfig = this.liveDataRendererConfiguration.getLiveDataConfiguration(this.convertParams(queryConfig));
            return this.query(liveDataConfig.getQuery());
        }
        catch (Exception e) {
            this.logger.warn("Failed to create the live data query from [{}]. Root cause is [{}].", queryConfig, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return null;
        }
    }

    public LiveData query(String queryConfigJSON) {
        try {
            return this.query((Map)new ObjectMapper().readValue(queryConfigJSON, Map.class));
        }
        catch (JsonProcessingException e) {
            this.logger.warn("Failed to convert the live data query parameters to a Map. Root cause is [{}].", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return null;
        }
    }

    private LiveData query(LiveDataQuery query) {
        Optional<LiveDataSource> source = this.sourceManager.get(query.getSource());
        if (source.isPresent()) {
            try {
                return source.get().getEntries().get(query);
            }
            catch (LiveDataException e) {
                this.logger.warn("Failed to execute live data query. Root cause is [{}].", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return null;
    }

    public Map<String, Object> effectiveConfig(Map<String, Object> liveDataConfig) {
        try {
            return this.configHelper.effectiveConfig(liveDataConfig);
        }
        catch (Exception e) {
            this.logger.warn("Failed to compute the effective live data configuration for [{}]. Root cause is [{}].", liveDataConfig, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return null;
        }
    }

    public String effectiveConfig(String liveDataConfigJSON) {
        try {
            return this.configHelper.effectiveConfig(liveDataConfigJSON);
        }
        catch (Exception e) {
            this.logger.warn("Failed to compute the effective live data configuration for JSON [{}]. Root cause is [{}].", (Object)liveDataConfigJSON, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return null;
        }
    }

    @Unstable
    public Block execute(Map<String, Object> parameters) throws LiveDataException {
        return this.execute(parameters, null);
    }

    @Unstable
    public Block execute(Map<String, Object> parameters, Map<?, ?> advancedParameters) throws LiveDataException {
        return this.liveDataRenderer.execute(this.convertParams(parameters), advancedParameters, false);
    }

    @Unstable
    public String render(Map<String, Object> parameters) throws LiveDataException {
        return this.render(parameters, null);
    }

    @Unstable
    public String render(Map<String, Object> parameters, Map<?, ?> advancedParameters) throws LiveDataException {
        return this.liveDataRenderer.render(this.convertParams(parameters), advancedParameters, false);
    }

    public <S extends ScriptService> S get(String serviceName) {
        return (S)this.scriptServiceManager.get("liveData." + serviceName);
    }

    private LiveDataRendererParameters convertParams(Map<String, Object> parameters) throws LiveDataException {
        LiveDataRendererParameters liveDataRendererParameters = new LiveDataRendererParameters();
        for (Map.Entry<String, Object> stringObjectEntry : parameters.entrySet()) {
            try {
                PropertyUtils.setProperty((Object)liveDataRendererParameters, (String)stringObjectEntry.getKey(), (Object)stringObjectEntry.getValue());
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new LiveDataException(String.format("Failed to set property [%s] with value [%s] in object [%s]", stringObjectEntry.getKey(), stringObjectEntry.getValue(), liveDataRendererParameters), e);
            }
        }
        return liveDataRendererParameters;
    }
}

