/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.livedata.internal;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.icon.IconException;
import org.xwiki.icon.IconManager;
import org.xwiki.livedata.LiveDataActionDescriptor;
import org.xwiki.livedata.LiveDataConfiguration;
import org.xwiki.livedata.LiveDataConfigurationResolver;
import org.xwiki.livedata.LiveDataException;
import org.xwiki.livedata.LiveDataLayoutDescriptor;
import org.xwiki.livedata.LiveDataPropertyDescriptor;
import org.xwiki.livedata.LiveDataQuery;

@Component
@Singleton
public class StringLiveDataConfigurationResolver
implements LiveDataConfigurationResolver<String> {
    private static final String QUERY = "query";
    private static final String PROPERTIES = "properties";
    private static final String SOURCE = "source";
    private static final String SORT = "sort";
    private static final String PROPERTY = "property";
    private static final String LIMIT = "limit";
    private static final String OFFSET = "offset";
    private static final String META = "meta";
    private static final String ICON = "icon";
    private static final String DISPLAYER = "displayer";
    private static final String FILTER = "filter";
    private static final String DISPLAYERS = "displayers";
    private static final String FILTERS = "filters";
    private static final String LAYOUTS = "layouts";
    private static final String ACTIONS = "actions";
    private static final String CSS_CLASS = "cssClass";
    private static final String EXTRA_ICON_CLASSES = "extraIconClasses";
    @Inject
    private Logger logger;
    @Inject
    private IconManager iconManager;

    @Override
    public LiveDataConfiguration resolve(String liveDataConfigJSON) throws LiveDataException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            JsonNode liveDataConfig = objectMapper.readTree(liveDataConfigJSON);
            liveDataConfig = this.normalizeConfig(liveDataConfig, objectMapper);
            return (LiveDataConfiguration)objectMapper.readerFor(LiveDataConfiguration.class).readValue(liveDataConfig);
        }
        catch (IOException e) {
            throw new LiveDataException(e);
        }
    }

    private ObjectNode normalizeConfig(JsonNode liveDataConfig, ObjectMapper objectMapper) {
        if (liveDataConfig.isObject()) {
            ObjectNode liveDataConfigObj = (ObjectNode)liveDataConfig;
            this.normalizeQueryConfig(liveDataConfigObj, objectMapper);
            this.normalizeMetaConfig(liveDataConfigObj, objectMapper);
            return liveDataConfigObj;
        }
        return objectMapper.createObjectNode();
    }

    private void normalizeQueryConfig(ObjectNode liveDataConfig, ObjectMapper objectMapper) {
        JsonNode queryConfig = liveDataConfig.path(QUERY);
        if (queryConfig.isObject()) {
            ObjectNode queryConfigObj = (ObjectNode)queryConfig;
            if (!queryConfig.path(PROPERTIES).isArray()) {
                queryConfigObj.remove(PROPERTIES);
            }
            this.normalizeSourceConfig(queryConfigObj, objectMapper);
            this.normalizeSortConfig(queryConfigObj, objectMapper);
            this.normalizeQueryFiltersConfig("hiddenFilters", queryConfigObj, objectMapper);
            this.normalizeQueryFiltersConfig(FILTERS, queryConfigObj, objectMapper);
            if (!queryConfig.path(LIMIT).isNumber()) {
                queryConfigObj.remove(LIMIT);
            }
            if (!queryConfig.path(OFFSET).isNumber()) {
                queryConfigObj.remove(OFFSET);
            }
        } else {
            liveDataConfig.remove(QUERY);
        }
    }

    private void normalizeSourceConfig(ObjectNode queryConfig, ObjectMapper objectMapper) {
        JsonNode sourceConfig = queryConfig.path(SOURCE);
        if (sourceConfig.isTextual()) {
            LiveDataQuery.Source source = new LiveDataQuery.Source(sourceConfig.asText());
            queryConfig.set(SOURCE, objectMapper.valueToTree((Object)source));
        } else if (!sourceConfig.isObject()) {
            queryConfig.remove(SOURCE);
        }
    }

    private void normalizeSortConfig(ObjectNode queryConfig, ObjectMapper objectMapper) {
        JsonNode sortConfig = queryConfig.path(SORT);
        if (sortConfig.isTextual()) {
            LiveDataQuery.SortEntry sortEntry = new LiveDataQuery.SortEntry(sortConfig.asText());
            queryConfig.set(SORT, objectMapper.valueToTree((Object)new LiveDataQuery.SortEntry[]{sortEntry}));
        } else if (sortConfig.isObject() && sortConfig.has(PROPERTY)) {
            queryConfig.putArray(SORT).add(sortConfig);
        } else if (sortConfig.isArray()) {
            ArrayNode sortList = queryConfig.putArray(SORT);
            for (JsonNode sortEntry : (ArrayNode)sortConfig) {
                if (sortEntry.isTextual()) {
                    sortList.add(objectMapper.valueToTree((Object)new LiveDataQuery.SortEntry(sortEntry.asText())));
                    continue;
                }
                if (!sortEntry.isObject() || !sortEntry.has(PROPERTY)) continue;
                sortList.add(sortEntry);
            }
        } else {
            queryConfig.remove(SORT);
        }
    }

    private void normalizeQueryFiltersConfig(String filtersProperty, ObjectNode queryConfig, ObjectMapper objectMapper) {
        JsonNode filtersConfig = queryConfig.path(filtersProperty);
        if (filtersConfig.isObject()) {
            Iterator iterator = filtersConfig.fields();
            ArrayNode filters = queryConfig.putArray(filtersProperty);
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                LiveDataQuery.Filter filter = new LiveDataQuery.Filter((String)entry.getKey(), entry.getValue());
                filters.add(objectMapper.valueToTree((Object)filter));
            }
        } else if (!filtersConfig.isArray()) {
            queryConfig.remove(filtersProperty);
        }
    }

    private void normalizeMetaConfig(ObjectNode liveDataConfig, ObjectMapper objectMapper) {
        JsonNode metaConfig = liveDataConfig.path(META);
        if (metaConfig.isObject()) {
            ObjectNode metaConfigObj = (ObjectNode)metaConfig;
            this.normalizePropertyDescriptors("propertyDescriptors", metaConfigObj, objectMapper);
            this.normalizePropertyDescriptors("propertyTypes", metaConfigObj, objectMapper);
            this.normalizeLayouts(metaConfigObj, objectMapper);
            this.normalizeFilters(metaConfigObj, objectMapper);
            this.normalizeDisplayers(metaConfigObj, objectMapper);
            this.normalizeActions(metaConfigObj, objectMapper);
        } else {
            liveDataConfig.remove(META);
        }
    }

    private void normalizePropertyDescriptors(String fieldName, ObjectNode metaConfig, ObjectMapper objectMapper) {
        JsonNode propertyDescriptorsConfig = metaConfig.path(fieldName);
        if (propertyDescriptorsConfig.isArray()) {
            for (JsonNode entry : propertyDescriptorsConfig) {
                if (!entry.isObject()) continue;
                this.normalizePropertyDescriptor((ObjectNode)entry, objectMapper);
            }
        } else {
            metaConfig.remove(fieldName);
        }
    }

    private void normalizePropertyDescriptor(ObjectNode propertyDescriptor, ObjectMapper objectMapper) {
        this.normalizeIcon(propertyDescriptor, objectMapper);
        propertyDescriptor.set(FILTER, (JsonNode)this.normalizeFilter(propertyDescriptor.path(FILTER), objectMapper));
        propertyDescriptor.set(DISPLAYER, (JsonNode)this.normalizeDisplayer(propertyDescriptor.path(DISPLAYER), objectMapper));
    }

    private void normalizeIcon(ObjectNode descriptor, ObjectMapper objectMapper) {
        JsonNode icon = descriptor.path(ICON);
        if (icon.isTextual()) {
            try {
                Map iconMetaData = this.iconManager.getMetaData(icon.asText());
                descriptor.set(ICON, objectMapper.valueToTree((Object)iconMetaData));
            }
            catch (IconException e) {
                this.logger.warn("Failed to get icon meta data for [{}]. Root cause is [{}].", (Object)icon.asText(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                descriptor.remove(ICON);
            }
        } else if (!icon.isObject()) {
            descriptor.remove(ICON);
        }
        StringLiveDataConfigurationResolver.normalizeIconClasses(descriptor);
    }

    private static void normalizeIconClasses(ObjectNode descriptor) {
        JsonNode icon = descriptor.path(ICON);
        if (icon.isObject()) {
            JsonNode extraClasses = descriptor.path(EXTRA_ICON_CLASSES);
            if (extraClasses.isTextual()) {
                Object cssClasses = extraClasses.textValue().trim();
                if (icon.path(CSS_CLASS).isTextual()) {
                    cssClasses = icon.path(CSS_CLASS).textValue().trim() + " " + (String)cssClasses;
                }
                ((ObjectNode)icon).set(CSS_CLASS, (JsonNode)new TextNode((String)cssClasses));
            }
            descriptor.remove(EXTRA_ICON_CLASSES);
        }
    }

    private void normalizeLayouts(ObjectNode metaConfig, ObjectMapper objectMapper) {
        JsonNode layoutsConfig = metaConfig.path(LAYOUTS);
        if (layoutsConfig.isArray()) {
            ArrayNode layouts = metaConfig.putArray(LAYOUTS);
            for (JsonNode layout : layoutsConfig) {
                layouts.add(this.normalizeLayout(layout, objectMapper));
            }
        } else {
            metaConfig.remove(LAYOUTS);
        }
    }

    private JsonNode normalizeLayout(JsonNode layoutConfig, ObjectMapper objectMapper) {
        if (layoutConfig.isTextual()) {
            return objectMapper.valueToTree((Object)new LiveDataLayoutDescriptor(layoutConfig.asText()));
        }
        if (layoutConfig.isObject()) {
            this.normalizeIcon((ObjectNode)layoutConfig, objectMapper);
        }
        return layoutConfig;
    }

    private void normalizeFilters(ObjectNode metaConfig, ObjectMapper objectMapper) {
        JsonNode filtersConfig = metaConfig.path(FILTERS);
        if (filtersConfig.isArray()) {
            ArrayNode filters = metaConfig.putArray(FILTERS);
            for (JsonNode filter : filtersConfig) {
                ObjectNode filterConfig = this.normalizeFilter(filter, objectMapper);
                if (filterConfig == null) continue;
                filters.add((JsonNode)filterConfig);
            }
        } else {
            metaConfig.remove(FILTERS);
        }
    }

    private ObjectNode normalizeFilter(JsonNode filterConfig, ObjectMapper objectMapper) {
        if (filterConfig.isTextual()) {
            return (ObjectNode)objectMapper.valueToTree((Object)new LiveDataPropertyDescriptor.FilterDescriptor(filterConfig.asText()));
        }
        if (filterConfig.isObject()) {
            JsonNode operators = filterConfig.path("operators");
            if (operators.isArray()) {
                for (int i = 0; i < operators.size(); ++i) {
                    JsonNode operator = operators.get(i);
                    if (!operator.isTextual()) continue;
                    ObjectNode operatorObj = objectMapper.createObjectNode();
                    operatorObj.set("id", operator);
                    ((ArrayNode)operators).set(i, (JsonNode)operatorObj);
                }
            }
            return (ObjectNode)filterConfig;
        }
        return null;
    }

    private void normalizeDisplayers(ObjectNode metaConfig, ObjectMapper objectMapper) {
        JsonNode displayersConfig = metaConfig.path(DISPLAYERS);
        if (displayersConfig.isArray()) {
            ArrayNode displayers = metaConfig.putArray(DISPLAYERS);
            for (JsonNode displayer : displayersConfig) {
                ObjectNode displayerConfig = this.normalizeDisplayer(displayer, objectMapper);
                if (displayerConfig == null) continue;
                displayers.add((JsonNode)displayerConfig);
            }
        } else {
            metaConfig.remove(DISPLAYERS);
        }
    }

    private ObjectNode normalizeDisplayer(JsonNode displayerConfig, ObjectMapper objectMapper) {
        if (displayerConfig.isTextual()) {
            return (ObjectNode)objectMapper.valueToTree((Object)new LiveDataPropertyDescriptor.DisplayerDescriptor(displayerConfig.asText()));
        }
        if (displayerConfig.isObject()) {
            return (ObjectNode)displayerConfig;
        }
        return null;
    }

    private void normalizeActions(ObjectNode metaConfig, ObjectMapper objectMapper) {
        JsonNode actionsConfig = metaConfig.path(ACTIONS);
        if (actionsConfig.isArray()) {
            ArrayNode actions = metaConfig.putArray(ACTIONS);
            for (JsonNode action : actionsConfig) {
                actions.add(this.normalizeAction(action, objectMapper));
            }
        } else {
            metaConfig.remove(ACTIONS);
        }
    }

    private JsonNode normalizeAction(JsonNode actionConfig, ObjectMapper objectMapper) {
        if (actionConfig.isTextual()) {
            return objectMapper.valueToTree((Object)new LiveDataActionDescriptor(actionConfig.asText()));
        }
        if (actionConfig.isObject()) {
            this.normalizeIcon((ObjectNode)actionConfig, objectMapper);
        }
        return actionConfig;
    }
}

