/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.livedata.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;

public class JSONMerge {
    private static final String ID = "id";

    public <T> T merge(T ... objects) {
        if (objects == null) {
            return null;
        }
        return Stream.of(objects).reduce(null, this::merge);
    }

    private <T> T merge(T left, T right) {
        if (left == null && right == null) {
            return null;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode leftNode = objectMapper.valueToTree(left);
        JsonNode rightNode = objectMapper.valueToTree(right);
        Class<?> type = right != null ? right.getClass() : left.getClass();
        try {
            return (T)objectMapper.readerFor(type).readValue(this.merge(leftNode, rightNode));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private JsonNode merge(JsonNode left, JsonNode right) {
        if (right == null || right.isNull()) {
            return left;
        }
        if (left == null || !left.isObject() && !left.isArray() || !Objects.equals(left.getNodeType(), right.getNodeType())) {
            return right.deepCopy();
        }
        if (left.isObject()) {
            return this.merge((ObjectNode)left, (ObjectNode)right);
        }
        return this.merge((ArrayNode)left, (ArrayNode)right);
    }

    private ObjectNode merge(ObjectNode left, ObjectNode right) {
        if (right.has(ID) && !Objects.equals(left.get(ID), right.get(ID))) {
            return right.deepCopy();
        }
        Iterator fieldNames = right.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode leftField = left.get(fieldName);
            JsonNode rightField = right.get(fieldName);
            left.set(fieldName, this.merge(leftField, rightField));
        }
        return left;
    }

    private ArrayNode merge(ArrayNode left, ArrayNode right) {
        ArrayNode result = left.arrayNode();
        for (JsonNode rightItem : right) {
            JsonNode leftItem = this.findById(rightItem.path(ID), left);
            result.add(this.merge(leftItem, rightItem));
        }
        for (JsonNode leftItem : left) {
            if (!leftItem.hasNonNull(ID) || this.findById(leftItem.get(ID), right) != null) continue;
            result.add(leftItem.deepCopy());
        }
        return result;
    }

    private JsonNode findById(JsonNode id, ArrayNode array) {
        if (id != null && !id.isNull() && !id.isMissingNode()) {
            for (JsonNode item : array) {
                if (!id.equals((Object)item.path(ID))) continue;
                return item;
            }
        }
        return null;
    }
}

