/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.livedata.internal;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.livedata.LiveDataActionDescriptor;
import org.xwiki.livedata.LiveDataConfiguration;
import org.xwiki.livedata.LiveDataConfigurationResolver;
import org.xwiki.livedata.LiveDataException;
import org.xwiki.livedata.LiveDataLayoutDescriptor;
import org.xwiki.livedata.LiveDataMeta;
import org.xwiki.livedata.LiveDataPaginationConfiguration;
import org.xwiki.livedata.LiveDataPropertyDescriptor;
import org.xwiki.livedata.LiveDataQuery;
import org.xwiki.livedata.internal.JSONMerge;
import org.xwiki.localization.ContextualLocalizationManager;

@Component
@Singleton
public class DefaultLiveDataConfigurationResolver
implements LiveDataConfigurationResolver<LiveDataConfiguration> {
    @Inject
    private LiveDataConfigurationResolver<String> stringLiveDataConfigResolver;
    @Inject
    private ContextualLocalizationManager l10n;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    private JSONMerge jsonMerge = new JSONMerge();

    @Override
    public LiveDataConfiguration resolve(LiveDataConfiguration config) throws LiveDataException {
        try {
            return this.mergeBaseConfig(this.mergeSourceConfig(config));
        }
        catch (IOException e) {
            throw new LiveDataException(e);
        }
    }

    private LiveDataConfiguration mergeSourceConfig(LiveDataConfiguration config) throws LiveDataException {
        LiveDataQuery.Source source = config.getQuery() != null ? config.getQuery().getSource() : null;
        String hint = source != null ? source.getId() : null;
        DefaultParameterizedType role = new DefaultParameterizedType(null, LiveDataConfigurationResolver.class, new Type[]{LiveDataConfiguration.class});
        ComponentManager componentManager = (ComponentManager)this.componentManagerProvider.get();
        if (hint != null && !"".equals(hint) && !"default".equals(hint) && componentManager.hasComponent((Type)role, hint)) {
            try {
                LiveDataConfigurationResolver sourceConfigResolver = (LiveDataConfigurationResolver)componentManager.getInstance((Type)role, hint);
                return sourceConfigResolver.resolve(config);
            }
            catch (ComponentLookupException componentLookupException) {
                // empty catch block
            }
        }
        return config;
    }

    private LiveDataConfiguration mergeBaseConfig(LiveDataConfiguration config) throws LiveDataException, IOException {
        InputStream baseConfigInputStream = this.getClass().getResourceAsStream("/liveDataConfiguration.json");
        String baseConfigJSON = IOUtils.toString((InputStream)baseConfigInputStream, (String)"UTF-8");
        LiveDataConfiguration baseConfig = this.stringLiveDataConfigResolver.resolve(baseConfigJSON);
        baseConfig.setId(config.getId());
        LiveDataConfiguration mergedConfig = this.jsonMerge.merge(new LiveDataConfiguration[]{baseConfig, config});
        mergedConfig.initialize();
        Collection<LiveDataLayoutDescriptor> layout = null;
        if (config.getMeta() != null) {
            layout = config.getMeta().getLayouts();
        }
        this.handleLayouts(layout, mergedConfig.getMeta());
        this.handlePageSizes(mergedConfig);
        return this.translate(mergedConfig);
    }

    private void handlePageSizes(LiveDataConfiguration mergedConfiguration) {
        Integer limit = mergedConfiguration.getQuery().getLimit();
        if (limit != null) {
            List<Integer> pageSizes;
            LiveDataPaginationConfiguration pagination;
            LiveDataMeta meta = mergedConfiguration.getMeta();
            if (meta == null) {
                meta = new LiveDataMeta();
                mergedConfiguration.setMeta(meta);
            }
            if ((pagination = meta.getPagination()) == null) {
                pagination = new LiveDataPaginationConfiguration();
                meta.setPagination(pagination);
            }
            if ((pageSizes = pagination.getPageSizes()) == null) {
                pageSizes = new ArrayList<Integer>();
                pagination.setPageSizes(pageSizes);
            }
            if (!pageSizes.contains(limit)) {
                pageSizes.add(limit);
                Collections.sort(pageSizes);
            }
        }
    }

    private void handleLayouts(Collection<LiveDataLayoutDescriptor> configuredLayouts, LiveDataMeta mergedConfigMeta) {
        if (configuredLayouts != null && !configuredLayouts.isEmpty()) {
            mergedConfigMeta.setLayouts(configuredLayouts.stream().map(configLayout -> mergedConfigMeta.getLayouts().stream().filter(baseConfigLayout -> Objects.equals(baseConfigLayout.getId(), configLayout.getId())).findFirst().orElse((LiveDataLayoutDescriptor)configLayout)).collect(Collectors.toList()));
        }
    }

    private LiveDataConfiguration translate(LiveDataConfiguration config) {
        config.getMeta().getLayouts().stream().filter(Objects::nonNull).forEach(this::translate);
        config.getMeta().getFilters().stream().filter(Objects::nonNull).forEach(this::translate);
        config.getMeta().getActions().stream().filter(Objects::nonNull).forEach(this::translate);
        return config;
    }

    private void translate(LiveDataLayoutDescriptor layout) {
        if (layout.getName() == null && layout.getId() != null) {
            layout.setName(this.l10n.getTranslationPlain("liveData.layout." + layout.getId(), new Object[0]));
            if (layout.getName() == null) {
                layout.setName(layout.getId());
            }
        }
    }

    private void translate(LiveDataPropertyDescriptor.FilterDescriptor filter) {
        filter.getOperators().stream().filter(Objects::nonNull).forEach(this::translate);
    }

    private void translate(LiveDataPropertyDescriptor.OperatorDescriptor operator) {
        if (operator.getName() == null && operator.getId() != null) {
            operator.setName(this.l10n.getTranslationPlain("liveData.operator." + operator.getId(), new Object[0]));
            if (operator.getName() == null) {
                operator.setName(operator.getId());
            }
        }
    }

    private void translate(LiveDataActionDescriptor action) {
        if (action.getName() == null && action.getId() != null) {
            action.setName(this.l10n.getTranslationPlain("liveData.action." + action.getId(), new Object[0]));
            if (action.getName() == null) {
                action.setName(action.getId());
            }
        }
        if (action.getDescription() == null && action.getId() != null) {
            action.setDescription(this.l10n.getTranslationPlain(String.format("liveData.action.%s.hint", action.getId()), new Object[0]));
        }
    }
}

