/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.livedata;

import java.util.Map;
import java.util.Optional;
import org.xwiki.component.annotation.Role;
import org.xwiki.livedata.LiveData;
import org.xwiki.livedata.LiveDataException;
import org.xwiki.livedata.LiveDataQuery;

@Role
public interface LiveDataEntryStore {
    public Optional<Map<String, Object>> get(Object var1) throws LiveDataException;

    default public Optional<Object> get(Object entryId, String property) throws LiveDataException {
        Object value;
        Optional<Map<String, Object>> values = this.get(entryId);
        if (values.isPresent() && (value = values.get().get(property)) != null) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public LiveData get(LiveDataQuery var1) throws LiveDataException;

    default public Optional<Object> save(Map<String, Object> entry) throws LiveDataException {
        throw new UnsupportedOperationException();
    }

    default public Optional<Object> update(Object entryId, String property, Object value) throws LiveDataException {
        Optional<Map<String, Object>> entry = this.get(entryId);
        if (entry.isPresent()) {
            Object previousValue = entry.get().put(property, value);
            if (this.save(entry.get()).isPresent() && previousValue != null) {
                return Optional.of(previousValue);
            }
        }
        return Optional.empty();
    }

    default public Optional<Map<String, Object>> remove(Object entryId) throws LiveDataException {
        throw new UnsupportedOperationException();
    }
}

