/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.lesscss.compiler.LESSCompiler;
import org.xwiki.lesscss.compiler.LESSCompilerException;
import org.xwiki.lesscss.internal.cache.ColorThemeCache;
import org.xwiki.lesscss.internal.cache.LESSResourcesCache;
import org.xwiki.lesscss.internal.colortheme.ColorTheme;
import org.xwiki.lesscss.internal.colortheme.ColorThemeReference;
import org.xwiki.lesscss.internal.colortheme.ColorThemeReferenceFactory;
import org.xwiki.lesscss.internal.colortheme.LESSColorThemeConverter;
import org.xwiki.lesscss.internal.skin.SkinReference;
import org.xwiki.lesscss.internal.skin.SkinReferenceFactory;
import org.xwiki.lesscss.resources.LESSResourceReferenceFactory;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="lesscss")
@Singleton
public class LessCompilerScriptService
implements ScriptService {
    @Inject
    private LESSCompiler lessCompiler;
    @Inject
    private LESSResourceReferenceFactory lessResourceReferenceFactory;
    @Inject
    private LESSResourcesCache lessCache;
    @Inject
    private ColorThemeCache colorThemeCache;
    @Inject
    private LESSColorThemeConverter lessColorThemeConverter;
    @Inject
    private SkinReferenceFactory skinReferenceFactory;
    @Inject
    private ColorThemeReferenceFactory colorThemeReferenceFactory;
    @Inject
    private ContextualAuthorizationManager authorizationManager;

    public String compileSkinFile(String fileName) {
        return this.compileSkinFile(fileName, false);
    }

    public String compileSkinFile(String fileName, boolean force) {
        try {
            return this.lessCompiler.compile(this.lessResourceReferenceFactory.createReferenceForSkinFile(fileName), false, true, force);
        }
        catch (LESSCompilerException e) {
            return ExceptionUtils.getRootCauseMessage((Throwable)e);
        }
    }

    public String compileSkinFile(String fileName, String skin) {
        return this.compileSkinFile(fileName, skin, false);
    }

    public String compileSkinFile(String fileName, String skin, boolean force) {
        try {
            return this.lessCompiler.compile(this.lessResourceReferenceFactory.createReferenceForSkinFile(fileName), false, true, skin, force);
        }
        catch (LESSCompilerException e) {
            return ExceptionUtils.getRootCauseMessage((Throwable)e);
        }
    }

    public ColorTheme getColorThemeFromSkinFile(String filename) {
        try {
            return this.lessColorThemeConverter.getColorThemeFromSkinFile(filename, false);
        }
        catch (LESSCompilerException e) {
            return new ColorTheme();
        }
    }

    public ColorTheme getColorThemeFromSkinFile(String filename, String skin) {
        try {
            return this.lessColorThemeConverter.getColorThemeFromSkinFile(filename, skin, false);
        }
        catch (LESSCompilerException e) {
            return new ColorTheme();
        }
    }

    public boolean clearCache() {
        if (!this.authorizationManager.hasAccess(Right.PROGRAM)) {
            return false;
        }
        this.lessCache.clear();
        this.colorThemeCache.clear();
        return true;
    }

    public boolean clearCacheFromColorTheme(String colorTheme) {
        if (!this.authorizationManager.hasAccess(Right.PROGRAM)) {
            return false;
        }
        try {
            ColorThemeReference colorThemeReference = this.colorThemeReferenceFactory.createReference(colorTheme);
            this.lessCache.clearFromColorTheme(colorThemeReference);
            this.colorThemeCache.clearFromColorTheme(colorThemeReference);
            return true;
        }
        catch (LESSCompilerException e) {
            return false;
        }
    }

    public boolean clearCacheFromSkin(String skin) {
        if (!this.authorizationManager.hasAccess(Right.PROGRAM)) {
            return false;
        }
        try {
            SkinReference skinReference = this.skinReferenceFactory.createReference(skin);
            this.lessCache.clearFromSkin(skinReference);
            this.colorThemeCache.clearFromSkin(skinReference);
            return true;
        }
        catch (LESSCompilerException e) {
            return false;
        }
    }
}

