/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.listeners;

import com.xpn.xwiki.doc.XWikiDocument;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.lesscss.internal.cache.ColorThemeCache;
import org.xwiki.lesscss.internal.cache.LESSResourcesCache;
import org.xwiki.lesscss.internal.skin.SkinReference;
import org.xwiki.lesscss.internal.skin.SkinReferenceFactory;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="lessSkin")
@Singleton
@Priority(value=100)
public class SkinListener
implements EventListener {
    private static final LocalDocumentReference SKIN_CLASS = new LocalDocumentReference("XWiki", "XWikiSkins");
    @Inject
    private LESSResourcesCache lessResourcesCache;
    @Inject
    private ColorThemeCache colorThemeCache;
    @Inject
    private SkinReferenceFactory skinReferenceFactory;

    public String getName() {
        return "LESS Skin Listener";
    }

    public List<Event> getEvents() {
        return Arrays.asList(new DocumentCreatedEvent(), new DocumentUpdatedEvent(), new DocumentDeletedEvent());
    }

    public void onEvent(Event event, Object source, Object data) {
        XWikiDocument document = (XWikiDocument)source;
        List skinObjects = document.getXObjects((EntityReference)SKIN_CLASS);
        if (skinObjects != null && !skinObjects.isEmpty()) {
            this.clearCacheFromSkin(document);
            return;
        }
    }

    private void clearCacheFromSkin(XWikiDocument document) {
        SkinReference skinReference = this.skinReferenceFactory.createReference(document.getDocumentReference());
        this.lessResourcesCache.clearFromSkin(skinReference);
        this.colorThemeCache.clearFromSkin(skinReference);
    }
}

