/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.compiler;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.internal.template.InternalTemplateManager;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.Semaphore;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.lesscss.compiler.LESSCompilerException;
import org.xwiki.lesscss.internal.LESSConfiguration;
import org.xwiki.lesscss.internal.cache.CachedCompilerInterface;
import org.xwiki.lesscss.internal.compiler.less4j.Less4jCompiler;
import org.xwiki.lesscss.internal.resources.LESSSkinFileResourceReference;
import org.xwiki.lesscss.resources.LESSResourceReference;
import org.xwiki.lesscss.resources.WikiLESSResourceReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.template.Template;
import org.xwiki.template.TemplateManager;

@Component(roles={CachedLESSCompiler.class})
@Singleton
public class CachedLESSCompiler
implements CachedCompilerInterface<String>,
Initializable {
    public static final String MAIN_SKIN_STYLE_FILENAME = "style.less.vm";
    private static final String SKIN_CONTEXT_KEY = "skin";
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private Less4jCompiler less4JCompiler;
    @Inject
    private LESSConfiguration lessConfiguration;
    @Inject
    private TemplateManager templateManager;
    private Semaphore semaphore;

    public void initialize() throws InitializationException {
        this.semaphore = new Semaphore(this.lessConfiguration.getMaximumSimultaneousCompilations(), true);
    }

    @Override
    public String compute(LESSResourceReference lessResourceReference, boolean includeSkinStyle, boolean useVelocity, boolean useLESS, String skin) throws LESSCompilerException {
        StringWriter source = new StringWriter();
        try {
            String string;
            this.semaphore.acquire();
            if (lessResourceReference instanceof LESSSkinFileResourceReference || includeSkinStyle) {
                if (includeSkinStyle) {
                    source.write(String.format("@import (reference) \"%s\";%s", MAIN_SKIN_STYLE_FILENAME, System.lineSeparator()));
                }
                source.write(lessResourceReference.getContent(skin));
            }
            String lessCode = source.toString();
            if (useVelocity) {
                DocumentReference documentReference;
                DocumentReference authorReference;
                if (lessResourceReference instanceof WikiLESSResourceReference) {
                    authorReference = ((WikiLESSResourceReference)lessResourceReference).getAuthorReference();
                    documentReference = ((WikiLESSResourceReference)lessResourceReference).getDocumentReference();
                } else {
                    authorReference = InternalTemplateManager.SUPERADMIN_REFERENCE;
                    documentReference = null;
                }
                lessCode = this.evaluate(lessResourceReference.toString(), lessCode, skin, authorReference, documentReference);
            }
            if (useLESS) {
                string = this.less4JCompiler.compile(lessCode, skin, this.lessConfiguration.isGenerateInlineSourceMaps());
                return string;
            }
            string = lessCode;
            return string;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new LESSCompilerException("Current thread has been interrupted", (Exception)e);
        }
        catch (Exception e) {
            throw new LESSCompilerException(String.format("Failed to compile the resource [%s] with LESS.", lessResourceReference), e);
        }
        finally {
            this.semaphore.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String evaluate(String id, String source, String skin, DocumentReference authorReference, DocumentReference documentReference) throws Exception {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = xcontext.getWiki();
        String currentSkin = xwiki.getSkin(xcontext);
        try {
            if (!currentSkin.equals(skin)) {
                xcontext.put((Object)SKIN_CONTEXT_KEY, (Object)skin);
            }
            Template template = this.templateManager.createStringTemplate(id, source, authorReference, documentReference);
            StringWriter result = new StringWriter();
            this.templateManager.renderNoException(template, (Writer)result);
            String string = result.toString();
            return string;
        }
        finally {
            if (!currentSkin.equals(skin)) {
                xcontext.put((Object)SKIN_CONTEXT_KEY, (Object)currentSkin);
            }
        }
    }
}

