/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimacro.internal;

import com.xpn.xwiki.internal.mandatory.AbstractAsyncClassDocumentInitializer;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.TextAreaClass;
import java.util.Arrays;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.wikimacro.internal.WikiMacroConstants;

@Component
@Named(value="XWiki.WikiMacroClass")
@Singleton
public class WikiMacroClassDocumentInitializer
extends AbstractAsyncClassDocumentInitializer
implements WikiMacroConstants {
    private static final String PROPERTY_PIPE = "|";
    private static final String YESNO = "yesno";

    public WikiMacroClassDocumentInitializer() {
        super((EntityReference)WIKI_MACRO_CLASS_REFERENCE);
    }

    protected void createClass(BaseClass xclass) {
        xclass.addTextField("id", "Macro id", 30);
        xclass.addTextField("name", "Macro name", 30);
        xclass.addTextAreaField("description", "Macro description", 40, 5, TextAreaClass.ContentType.PURE_TEXT);
        xclass.addStaticListField("defaultCategories", "Default categories", 1, true, "", "input");
        xclass.addBooleanField("supportsInlineMode", "Supports inline mode", YESNO);
        xclass.addStaticListField("visibility", "Macro visibility", 1, false, "Current User|Current Wiki|Global", "select", PROPERTY_PIPE);
        xclass.addStaticListField("contentType", "Macro content availability", 1, false, "Optional|Mandatory|No content", "select", PROPERTY_PIPE);
        xclass.addStaticListField("contentJavaType", "Macro content type", 1, false, false, StringUtils.join(Arrays.asList("Unknown", "Wiki"), (String)PROPERTY_PIPE), "input", PROPERTY_PIPE, "Unknown", "allowed", true);
        xclass.addTextAreaField("contentDescription", "Content description (Not applicable for \"No content\" type)", 40, 5, TextAreaClass.ContentType.PURE_TEXT);
        xclass.addTextAreaField("code", "Macro code", 40, 20, TextAreaClass.EditorType.TEXT);
        xclass.addNumberField("priority", "Priority", 10, "integer");
        xclass.addBooleanField("executionIsolated", "Isolated Execution", YESNO, Boolean.FALSE);
        super.createClass(xclass);
    }
}

