/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimacro.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.properties.ConverterManager;
import org.xwiki.rendering.RenderingException;
import org.xwiki.rendering.async.AsyncContext;
import org.xwiki.rendering.async.internal.block.AbstractBlockAsyncRenderer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.CompositeBlock;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.MacroMarkerBlock;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.RawBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.MetadataBlockMatcher;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroContentParser;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.MacroDescriptor;
import org.xwiki.rendering.macro.descriptor.ParameterDescriptor;
import org.xwiki.rendering.macro.wikibridge.WikiMacro;
import org.xwiki.rendering.macro.wikibridge.WikiMacroBindingInitializer;
import org.xwiki.rendering.macro.wikibridge.WikiMacroExecutionFinishedEvent;
import org.xwiki.rendering.macro.wikibridge.WikiMacroExecutionStartsEvent;
import org.xwiki.rendering.macro.wikibridge.WikiMacroParameters;
import org.xwiki.rendering.macro.wikibridge.binding.WikiMacroBinding;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxType;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationException;
import org.xwiki.rendering.util.ErrorBlockGenerator;
import org.xwiki.rendering.wikimacro.internal.DefaultWikiMacro;
import org.xwiki.script.ScriptContextManager;
import org.xwiki.security.authorization.AuthorExecutor;

@Component(roles={DefaultWikiMacroRenderer.class})
public class DefaultWikiMacroRenderer
extends AbstractBlockAsyncRenderer {
    private static final String TM_FAILEDRESOLVECONTENTPLACEHOLDER = "rendering.wikimacro.error.failedResolveContentPlaceholder";
    private static final String TM_FAILEDRESOLVEPARAMETERPLACEHOLDER = "rendering.wikimacro.error.failedResolveParameterPlaceholder";
    @Deprecated
    private static final String MACRO_KEY = "macro";
    private static final String MACRO_BINDING = "wikimacro";
    @Deprecated
    private static final String MACRO_CONTENT_KEY = "content";
    @Deprecated
    private static final String MACRO_PARAMS_KEY = "params";
    @Deprecated
    private static final String MACRO_CONTEXT_KEY = "context";
    @Deprecated
    private static final String MACRO_DESCRIPTOR_KEY = "descriptor";
    private static final String BACKUP_CONTEXTBINDING_KEY = "wikimacro.backup.contextbinding";
    private static final String BACKUP_BINDING_KEY = "wikimacro.backup.binding";
    private static final String MACRO_DOC_KEY = "doc";
    private static final WikiMacroExecutionStartsEvent STARTEXECUTION_EVENT = new WikiMacroExecutionStartsEvent();
    private static final WikiMacroExecutionFinishedEvent ENDEXECUTION_EVENT = new WikiMacroExecutionFinishedEvent();
    private static final String MACRO_RESULT_KEY = "result";
    private static final BlockMatcher MACRO_MARKER_MATCHER = testedBlock -> testedBlock instanceof MacroMarkerBlock;
    private static final BlockMatcher PLACEHOLDERS_BLOCKMATCHER = testedBlock -> testedBlock instanceof RawBlock && (((RawBlock)testedBlock).getSyntax().getType().equals((Object)SyntaxType.XHTML) || ((RawBlock)testedBlock).getSyntax().getType().equals((Object)SyntaxType.HTML)) || testedBlock instanceof MacroMarkerBlock && (((MacroMarkerBlock)testedBlock).getId().equals("wikimacrocontent") || ((MacroMarkerBlock)testedBlock).getId().equals("wikimacroparameter"));
    private static final BlockMatcher MACROCONTENT_METADATA_MATCHER = testedBlock -> testedBlock instanceof MetaDataBlock && "true".equals(((MetaDataBlock)testedBlock).getMetaData().getMetaData("wikimacrocontent"));
    private static final BlockMatcher NON_GENERATED_CONTENT_METADATA_MATCHER = testedBlock -> testedBlock instanceof MetaDataBlock && ((MetaDataBlock)testedBlock).getMetaData().getMetaData("non-generated-content") != null;
    private static final Pattern HTML_PLACEHOLDER_PATTERN = Pattern.compile("<(span|div) data-wikimacro-id=(?:[\"'])([^\"']+)(?:[\"'])(?: name=(?:[\"'])([^\"']+)(?:[\"']))?(?:\\/>|><\\/(?:span|div)>)");
    @Inject
    private AsyncContext asyncContext;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private ObservationManager observation;
    @Inject
    private ScriptContextManager scriptContextManager;
    @Inject
    private MacroContentParser contentParser;
    @Inject
    private ErrorBlockGenerator errorBlockGenerator;
    @Inject
    @Named(value="plain/1.0")
    private Parser plainTextParser;
    @Inject
    private Execution execution;
    @Inject
    private AuthorExecutor authorExecutor;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> currentResolver;
    @Inject
    private Logger logger;
    private DefaultWikiMacro wikimacro;
    private List<String> id;
    private WikiMacroParameters parameters;
    private WikiMacroParameters originalParameters;
    private String macroContent;
    private boolean inline;
    private Syntax targetSyntax;
    private MacroTransformationContext syncContext;
    private DocumentReference sourceAuthorReference;
    private DocumentReference sourceReference;

    void initialize(DefaultWikiMacro wikimacro, WikiMacroParameters parameters, String macroContent, MacroTransformationContext syncContext) {
        this.wikimacro = wikimacro;
        this.originalParameters = parameters;
        this.macroContent = macroContent;
        this.inline = syncContext.isInline();
        this.targetSyntax = syncContext.getTransformationContext().getTargetSyntax();
        this.syncContext = syncContext;
        this.id = this.createId(new Object[]{"rendering", MACRO_BINDING, wikimacro.getId(), wikimacro.getBlockId(syncContext.getCurrentMacroBlock())});
        try {
            this.parameters = this.convertParameters(parameters);
        }
        catch (ComponentLookupException e) {
            this.logger.error("Error while converting wikimacro parameters value.", (Throwable)e);
        }
        this.sourceAuthorReference = ((XWikiContext)this.xcontextProvider.get()).getAuthorReference();
        this.sourceReference = this.getSourceReference(syncContext);
    }

    private DocumentReference getSourceReference(MacroTransformationContext syncContext) {
        MetaDataBlock metaDataBlock;
        MacroBlock block;
        String reference = "";
        if (syncContext != null && (block = syncContext.getCurrentMacroBlock()) != null && (metaDataBlock = (MetaDataBlock)block.getFirstBlock((BlockMatcher)new MetadataBlockMatcher("source"), Block.Axes.ANCESTOR)) != null) {
            reference = (String)metaDataBlock.getMetaData().getMetaData("source");
        }
        return this.currentResolver.resolve((Object)reference, new Object[0]);
    }

    public List<String> getId() {
        return this.id;
    }

    public boolean isAsyncAllowed() {
        return this.wikimacro.isAsyncAllowed();
    }

    public boolean isCacheAllowed() {
        return this.wikimacro.isCacheAllowed();
    }

    public boolean isInline() {
        return this.inline;
    }

    public Syntax getTargetSyntax() {
        return this.targetSyntax;
    }

    private Block extractResult(Block block, WikiMacroBinding macroBinding, boolean async) {
        Object result;
        Object resultObject = macroBinding.getResult();
        if (resultObject == null) {
            resultObject = ((Map)((XWikiContext)this.xcontextProvider.get()).get((Object)MACRO_KEY)).get(MACRO_RESULT_KEY);
        }
        if (resultObject instanceof List) {
            result = new CompositeBlock((List)resultObject);
        } else if (resultObject instanceof Block) {
            result = (Block)resultObject;
        } else {
            result = !async ? new CompositeBlock(block.getChildren()) : block;
            if (this.inline) {
                result = this.removeTopLevelParagraph((Block)result);
            }
        }
        return result;
    }

    private XDOM prepareWikiMacroContent() {
        List children;
        XDOM xdom = this.wikimacro.getPreparedContent().clone();
        if (this.inline && !(children = xdom.getChildren()).isEmpty() && children.get(0) instanceof MacroBlock) {
            MacroBlock old = (MacroBlock)children.get(0);
            MacroBlock replacement = new MacroBlock(old.getId(), old.getParameters(), old.getContent(), true);
            xdom.replaceChild((Block)replacement, (Block)old);
        }
        return xdom;
    }

    public Block execute(boolean async, boolean cached) throws RenderingException {
        this.asyncContext.useComponent(this.wikimacro.getRoleType(), this.wikimacro.getRoleHint());
        XDOM macroXDOM = this.prepareWikiMacroContent();
        return this.transform(macroXDOM, async, cached);
    }

    private WikiMacroBinding createBinding(boolean async) {
        DocumentReference macroDocumentReference = this.wikimacro.getDocumentReference();
        HashMap<String, Object> contextMacroBinding = new HashMap<String, Object>();
        contextMacroBinding.put(MACRO_PARAMS_KEY, this.originalParameters);
        contextMacroBinding.put(MACRO_CONTENT_KEY, this.macroContent);
        contextMacroBinding.put(MACRO_DESCRIPTOR_KEY, this.wikimacro.getDescriptor());
        contextMacroBinding.put(MACRO_RESULT_KEY, null);
        if (!async) {
            contextMacroBinding.put(MACRO_CONTEXT_KEY, this.syncContext);
        }
        WikiMacroBinding macroBinding = null;
        try {
            ComponentManager currentComponentManager = (ComponentManager)this.componentManagerProvider.get();
            XWikiContext xWikiContext = (XWikiContext)this.xcontextProvider.get();
            Document document = new Document(xWikiContext.getWiki().getDocument(macroDocumentReference, xWikiContext), xWikiContext);
            contextMacroBinding.put(MACRO_DOC_KEY, document);
            macroBinding = new WikiMacroBinding(this.wikimacro.getDescriptor(), this.parameters, this.macroContent, async ? null : this.syncContext);
            macroBinding.put((Object)MACRO_DOC_KEY, (Object)document);
            List bindingInitializers = currentComponentManager.getInstanceList(org.xwiki.rendering.macro.wikibridge.binding.WikiMacroBindingInitializer.class);
            for (org.xwiki.rendering.macro.wikibridge.binding.WikiMacroBindingInitializer bindingInitializer : bindingInitializers) {
                bindingInitializer.initialize((WikiMacro)this.wikimacro, this.parameters, this.macroContent, async ? null : this.syncContext, macroBinding);
            }
            List oldBindingInitializers = currentComponentManager.getInstanceList(WikiMacroBindingInitializer.class);
            for (WikiMacroBindingInitializer bindingInitializer : oldBindingInitializers) {
                bindingInitializer.initialize((WikiMacro)this.wikimacro, this.parameters, this.macroContent, async ? null : this.syncContext, contextMacroBinding);
            }
            xWikiContext.put((Object)MACRO_KEY, contextMacroBinding);
            this.scriptContextManager.getCurrentScriptContext().setAttribute(MACRO_BINDING, macroBinding, 100);
            this.backupBindings(contextMacroBinding, macroBinding);
        }
        catch (XWikiException | ComponentLookupException e) {
            this.logger.error("Error while performing wikimacro binding.", e);
        }
        return macroBinding;
    }

    private void backupBindings(Map<String, Object> contextBinding, WikiMacroBinding wikiMacroBinding) {
        ExecutionContext econtext = this.execution.getContext();
        LinkedList<Map<String, Object>> backupContextBinding = (LinkedList<Map<String, Object>>)econtext.getProperty(BACKUP_CONTEXTBINDING_KEY);
        if (backupContextBinding == null) {
            backupContextBinding = new LinkedList<Map<String, Object>>();
            econtext.newProperty(BACKUP_CONTEXTBINDING_KEY).initial(backupContextBinding).makeFinal().inherited().declare();
        }
        backupContextBinding.push(contextBinding);
        LinkedList<WikiMacroBinding> backupWikiMacroBinding = (LinkedList<WikiMacroBinding>)econtext.getProperty(BACKUP_BINDING_KEY);
        if (backupWikiMacroBinding == null) {
            backupWikiMacroBinding = new LinkedList<WikiMacroBinding>();
            econtext.newProperty(BACKUP_BINDING_KEY).initial(backupWikiMacroBinding).makeFinal().inherited().declare();
        }
        backupWikiMacroBinding.push(wikiMacroBinding);
    }

    private void restoreBindingsOrClean() {
        ExecutionContext econtext = this.execution.getContext();
        Deque backupContextBinding = (Deque)econtext.getProperty(BACKUP_CONTEXTBINDING_KEY);
        backupContextBinding.pop();
        if (!backupContextBinding.isEmpty()) {
            ((XWikiContext)this.xcontextProvider.get()).put((Object)MACRO_KEY, backupContextBinding.peek());
        } else {
            ((XWikiContext)this.xcontextProvider.get()).remove((Object)MACRO_KEY);
        }
        Deque backupWikiMacroBinding = (Deque)econtext.getProperty(BACKUP_BINDING_KEY);
        backupWikiMacroBinding.pop();
        if (!backupWikiMacroBinding.isEmpty()) {
            WikiMacroBinding newMacroBinding = (WikiMacroBinding)backupWikiMacroBinding.peek();
            WikiMacroBinding oldBinding = (WikiMacroBinding)this.scriptContextManager.getCurrentScriptContext().getAttribute(MACRO_BINDING);
            oldBinding.replaceAll(newMacroBinding);
        } else {
            this.scriptContextManager.getCurrentScriptContext().removeAttribute(MACRO_BINDING, 100);
        }
    }

    private WikiMacroParameters convertParameters(WikiMacroParameters parameters) throws ComponentLookupException {
        ConverterManager converterManager = (ConverterManager)((ComponentManager)this.componentManagerProvider.get()).getInstance(ConverterManager.class);
        Map parameterDescriptorMap = this.wikimacro.getDescriptor().getParameterDescriptorMap();
        WikiMacroParameters result = new WikiMacroParameters();
        for (String parameterName : parameters.getParameterNames()) {
            Object value = parameters.get(parameterName);
            if (parameterDescriptorMap.containsKey(parameterName.toLowerCase())) {
                ParameterDescriptor parameterDescriptor = (ParameterDescriptor)parameterDescriptorMap.get(parameterName.toLowerCase());
                Type parameterType = parameterDescriptor.getParameterType();
                try {
                    value = converterManager.convert(parameterType, value);
                }
                catch (Exception e) {
                    continue;
                }
            }
            result.set(parameterName, value);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Block transform(XDOM macroXDOM, boolean async, boolean cached) throws RenderingException {
        XDOM xdom;
        XDOM block;
        WikiMacroBinding macroBinding = this.createBinding(async);
        try {
            block19: {
                MetaDataBlock syncMetaDataBlock;
                if (async) {
                    block = macroXDOM;
                    xdom = macroXDOM;
                    syncMetaDataBlock = null;
                } else {
                    MacroBlock wikiMacroBlock = this.syncContext.getCurrentMacroBlock();
                    MacroMarkerBlock wikiMacroMarker = new MacroMarkerBlock(wikiMacroBlock.getId(), wikiMacroBlock.getParameters(), wikiMacroBlock.getContent(), macroXDOM.getChildren(), wikiMacroBlock.isInline());
                    syncMetaDataBlock = new MetaDataBlock(Collections.singletonList(wikiMacroMarker), macroXDOM.getMetaData());
                    wikiMacroBlock.getParent().replaceChild((Block)syncMetaDataBlock, (Block)wikiMacroBlock);
                    wikiMacroBlock.setParent(syncMetaDataBlock.getParent());
                    wikiMacroBlock.setNextSiblingBlock(syncMetaDataBlock.getNextSibling());
                    wikiMacroBlock.setPreviousSiblingBlock(syncMetaDataBlock.getPreviousSibling());
                    block = wikiMacroMarker;
                    xdom = this.syncContext.getXDOM();
                }
                try {
                    this.observation.notify((Event)STARTEXECUTION_EVENT, (Object)this.wikimacro, (Object)macroBinding);
                    block = this.transform((Block)block, xdom, macroBinding, async);
                    if (syncMetaDataBlock == null) break block19;
                }
                catch (Throwable throwable) {
                    if (syncMetaDataBlock != null) {
                        syncMetaDataBlock.getParent().replaceChild((Block)this.syncContext.getCurrentMacroBlock(), syncMetaDataBlock);
                    }
                    this.observation.notify((Event)ENDEXECUTION_EVENT, (Object)this.wikimacro);
                    throw throwable;
                }
                syncMetaDataBlock.getParent().replaceChild((Block)this.syncContext.getCurrentMacroBlock(), (Block)syncMetaDataBlock);
            }
            this.observation.notify((Event)ENDEXECUTION_EVENT, (Object)this.wikimacro);
        }
        catch (Exception ex) {
            throw new RenderingException("Error while performing internal macro transformations", (Throwable)ex);
        }
        finally {
            this.restoreBindingsOrClean();
        }
        block = this.resolveMacroPlaceholders((Block)block);
        this.cleanMacroMarkers((Block)block);
        if (async || cached) {
            try (AutoCloseable closable = this.authorExecutor.before(this.sourceAuthorReference, this.sourceReference);){
                this.transform((Block)block, xdom, async);
            }
            catch (Exception e) {
                throw new RenderingException("Error while performing transformations of resolved", (Throwable)e);
            }
        }
        return block;
    }

    private Block resolveMacroPlaceholders(Block block) {
        Block replacedBlock = this.replacePlaceHolder(block);
        if (replacedBlock != block) {
            return replacedBlock;
        }
        List placeholders = block.getBlocks(PLACEHOLDERS_BLOCKMATCHER, Block.Axes.DESCENDANT);
        for (Block placeholder : placeholders) {
            replacedBlock = this.replacePlaceHolder(placeholder);
            if (replacedBlock == block) continue;
            placeholder.getParent().replaceChild(replacedBlock, placeholder);
        }
        return block;
    }

    private Block replacePlaceHolder(Block block) {
        RawBlock rawBlock;
        if (block instanceof MacroMarkerBlock) {
            MacroMarkerBlock macroBlock = (MacroMarkerBlock)block;
            if (macroBlock.getId().equals("wikimacrocontent")) {
                return this.resolveMacroContent(macroBlock);
            }
            if (macroBlock.getId().equals("wikimacroparameter")) {
                return this.resolveMacroParameter(macroBlock);
            }
        } else if (block instanceof RawBlock && ((rawBlock = (RawBlock)block).getSyntax().getType().equals((Object)SyntaxType.XHTML) || rawBlock.getSyntax().getType().equals((Object)SyntaxType.HTML))) {
            return this.replaceHTMLPlaceHolder(rawBlock);
        }
        return block;
    }

    private Block replaceHTMLPlaceHolder(RawBlock rawBlock) {
        Matcher matcher = HTML_PLACEHOLDER_PATTERN.matcher(rawBlock.getRawContent());
        if (matcher.find()) {
            CompositeBlock replacedBlock = new CompositeBlock();
            int previousIndex = 0;
            do {
                String macroId = matcher.group(2);
                boolean isInline = matcher.group(1).equals("span");
                replacedBlock.addChild((Block)new RawBlock(rawBlock.getRawContent().substring(previousIndex, matcher.start()), rawBlock.getSyntax()));
                if (macroId.equals("wikimacrocontent")) {
                    replacedBlock.addChild(this.resolveMacroContent(new MacroMarkerBlock(macroId, Collections.emptyMap(), Collections.emptyList(), isInline)));
                } else {
                    replacedBlock.addChild(this.resolveMacroParameter(new MacroMarkerBlock(macroId, Collections.singletonMap("name", matcher.group(3)), Collections.emptyList(), isInline)));
                }
                previousIndex = matcher.end();
            } while (matcher.find());
            replacedBlock.addChild((Block)new RawBlock(rawBlock.getRawContent().substring(previousIndex, rawBlock.getRawContent().length()), rawBlock.getSyntax()));
            return replacedBlock;
        }
        return rawBlock;
    }

    private Block resolveMacroContent(MacroMarkerBlock macroBlock) {
        if (this.wikimacro.getDescriptor().getContentDescriptor() != null && this.macroContent != null) {
            List blocks;
            MetaData nonGeneratedContentMetaData = this.getNonGeneratedContentMetaData();
            nonGeneratedContentMetaData.addMetaData("wikimacrocontent", (Object)"true");
            try {
                blocks = this.parseContent(this.macroContent, macroBlock.isInline()).getChildren();
            }
            catch (RenderingException e) {
                blocks = this.errorBlockGenerator.generateErrorBlocks(macroBlock.isInline(), TM_FAILEDRESOLVECONTENTPLACEHOLDER, "Failed to resolve macro content placeholder", null, new Object[]{e});
            }
            return new MetaDataBlock(blocks, nonGeneratedContentMetaData);
        }
        return macroBlock;
    }

    private XDOM parseWiki(String macroContent, Syntax syntax, boolean transform, boolean inline) throws RenderingException {
        try {
            return this.contentParser.parse(macroContent, syntax, this.syncContext, transform, null, inline);
        }
        catch (MacroExecutionException e) {
            throw new RenderingException("Failed to parse the passed content", (Throwable)e);
        }
    }

    private XDOM parseContent(String macroContent, boolean inline) throws RenderingException {
        ContentDescriptor contentDescriptor = this.wikimacro.getDescriptor().getContentDescriptor();
        if (contentDescriptor == null || !contentDescriptor.getType().equals(Block.LIST_BLOCK_TYPE)) {
            try {
                return this.plainTextParser.parse((Reader)new StringReader(macroContent));
            }
            catch (ParseException e) {
                throw new RenderingException("Error while parsing the macro content in plain text.", (Throwable)e);
            }
        }
        return this.parseWiki(macroContent, null, false, inline);
    }

    private Block resolveMacroParameter(MacroMarkerBlock macroBlock) {
        String parameterName = macroBlock.getParameter("name");
        Object parameterValue = this.originalParameters.get(parameterName);
        if (parameterValue instanceof String) {
            List blocks;
            MetaData nonGeneratedContentMetaData = this.getNonGeneratedParameterMetaData(parameterName);
            nonGeneratedContentMetaData.addMetaData("wikimacrocontent", (Object)"true");
            try {
                blocks = this.parseParameterValue((String)parameterValue, parameterName, macroBlock.isInline()).getChildren();
            }
            catch (Exception e) {
                blocks = this.errorBlockGenerator.generateErrorBlocks(macroBlock.isInline(), TM_FAILEDRESOLVEPARAMETERPLACEHOLDER, "Failed to resolve macro parameter placeholder", null, new Object[]{e});
            }
            return new MetaDataBlock(blocks, nonGeneratedContentMetaData);
        }
        return macroBlock;
    }

    private XDOM parseParameterValue(String macroParameterContent, String macroParameterName, boolean inline) throws MacroExecutionException, RenderingException {
        MacroDescriptor macroDescriptor = this.wikimacro.getDescriptor();
        ParameterDescriptor parameterDescriptor = null;
        if (macroDescriptor != null) {
            parameterDescriptor = (ParameterDescriptor)macroDescriptor.getParameterDescriptorMap().get(macroParameterName);
        }
        if (parameterDescriptor == null || !parameterDescriptor.getParameterType().equals(Block.LIST_BLOCK_TYPE)) {
            try {
                return this.plainTextParser.parse((Reader)new StringReader(macroParameterContent));
            }
            catch (ParseException e) {
                throw new MacroExecutionException("Error while parsing the macro parameter content in plain.", (Throwable)e);
            }
        }
        boolean executeWithMacroAuthor = Objects.equals(macroParameterContent, parameterDescriptor.getDefaultValue());
        if (executeWithMacroAuthor) {
            return this.parseWiki(macroParameterContent, this.wikimacro.getSourceSyntax(), true, inline);
        }
        return this.parseWiki(macroParameterContent, null, false, inline);
    }

    private MetaData getNonGeneratedContentMetaData() {
        ContentDescriptor contentDescriptor = this.wikimacro.getDescriptor().getContentDescriptor();
        return AbstractMacro.getNonGeneratedContentMetaData((ContentDescriptor)contentDescriptor);
    }

    private MetaData getNonGeneratedParameterMetaData(String parameterName) {
        MacroDescriptor macroDescriptor = this.wikimacro.getDescriptor();
        return AbstractMacro.getNonGeneratedContentMetaData((Map)macroDescriptor.getParameterDescriptorMap(), (String)parameterName);
    }

    private void cleanMacroMarkers(Block block) {
        List allMacroMarkerBlocks = block.getBlocks(MACRO_MARKER_MATCHER, Block.Axes.DESCENDANT);
        List allWikiMacroContentMetadataBlocks = block.getBlocks(MACROCONTENT_METADATA_MATCHER, Block.Axes.DESCENDANT);
        List allNonGeneratedContentMetadataBlocks = block.getBlocks(NON_GENERATED_CONTENT_METADATA_MATCHER, Block.Axes.DESCENDANT);
        if (!allWikiMacroContentMetadataBlocks.isEmpty()) {
            for (Block allWikiMacroContentMarkerBlock : allWikiMacroContentMetadataBlocks) {
                allMacroMarkerBlocks.removeAll(allWikiMacroContentMarkerBlock.getBlocks(MACRO_MARKER_MATCHER, Block.Axes.DESCENDANT));
                allNonGeneratedContentMetadataBlocks.removeAll(allWikiMacroContentMarkerBlock.getBlocks(NON_GENERATED_CONTENT_METADATA_MATCHER, Block.Axes.DESCENDANT_OR_SELF));
            }
            for (Block markerBlock : allMacroMarkerBlocks) {
                markerBlock.getParent().replaceChild(markerBlock.getChildren(), markerBlock);
            }
            for (Block nonGeneratedContentMetadataBlock : allNonGeneratedContentMetadataBlocks) {
                nonGeneratedContentMetadataBlock.getParent().replaceChild(nonGeneratedContentMetadataBlock.getChildren(), nonGeneratedContentMetadataBlock);
            }
        }
    }

    private Block transform(Block block, XDOM xdom, WikiMacroBinding macroBinding, boolean async) throws TransformationException {
        this.transform(block, xdom, async);
        return this.extractResult(block, macroBinding, async);
    }

    private void transform(Block block, XDOM xdom, boolean async) throws TransformationException {
        TransformationContext transformationContext = new TransformationContext(xdom, this.wikimacro.getSourceSyntax());
        transformationContext.setTargetSyntax(this.targetSyntax);
        if (!async) {
            transformationContext.setId(this.syncContext.getTransformationContext().getId());
        }
        this.transform(block, transformationContext);
    }
}

