/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimacro.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.runtime.internal.AroundClosure;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.context.Execution;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.properties.PropertyGroupDescriptor;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.macro.MacroId;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultParameterDescriptor;
import org.xwiki.rendering.macro.descriptor.MacroDescriptor;
import org.xwiki.rendering.macro.wikibridge.WikiMacro;
import org.xwiki.rendering.macro.wikibridge.WikiMacroDescriptor;
import org.xwiki.rendering.macro.wikibridge.WikiMacroException;
import org.xwiki.rendering.macro.wikibridge.WikiMacroFactory;
import org.xwiki.rendering.macro.wikibridge.WikiMacroParameterDescriptor;
import org.xwiki.rendering.macro.wikibridge.WikiMacroVisibility;
import org.xwiki.rendering.wikimacro.internal.DefaultWikiMacro;
import org.xwiki.rendering.wikimacro.internal.DefaultWikiMacroFactoryAspect;
import org.xwiki.rendering.wikimacro.internal.WikiMacroConstants;
import org.xwiki.security.authorization.DocumentAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Singleton
public class DefaultWikiMacroFactory
implements WikiMacroFactory,
WikiMacroConstants {
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Execution execution;
    @Inject
    private DocumentAuthorizationManager authorization;
    @Inject
    private Logger logger;

    private XWikiContext getContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    public WikiMacro createWikiMacro(DocumentReference documentReference) throws WikiMacroException {
        XWikiDocument doc;
        try {
            doc = this.getContext().getWiki().getDocument(documentReference, this.getContext());
        }
        catch (XWikiException e) {
            throw new WikiMacroException(String.format("Could not build macro from : [%s], unable to load document", documentReference), (Throwable)e);
        }
        try {
            return this.buildMacro(doc);
        }
        catch (Exception e) {
            throw new WikiMacroException(String.format("Failed to create a wiki macro for document [%s]", documentReference), (Throwable)e);
        }
    }

    private WikiMacro buildMacro(XWikiDocument doc) throws WikiMacroException, WikiComponentException, ComponentLookupException {
        BaseObject baseObject;
        DefaultWikiMacroFactory defaultWikiMacroFactory;
        Set macroDefaultCategories;
        boolean macroSupportsInlineMode;
        DocumentReference documentReference = doc.getDocumentReference();
        BaseObject macroDefinition = doc.getXObject((EntityReference)WIKI_MACRO_CLASS_REFERENCE);
        if (null == macroDefinition) {
            throw new WikiMacroException(String.format("No macro definition found in document : [%s]", documentReference));
        }
        String macroId = this.getMacroId(macroDefinition);
        if (macroId == null) {
            return null;
        }
        String macroName = this.getMacroName(macroDefinition, macroId);
        String macroDescription = macroDefinition.getStringValue("description");
        WikiMacroVisibility macroVisibility = WikiMacroVisibility.fromString((String)macroDefinition.getStringValue("visibility"));
        boolean bl = macroSupportsInlineMode = macroDefinition.getIntValue("supportsInlineMode") != 0;
        if (StringUtils.isEmpty((CharSequence)macroDescription)) {
            this.logger.debug("Incomplete macro definition in [{}], macro description is empty", (Object)documentReference);
        }
        if (CollectionUtils.isEmpty((Collection)(macroDefaultCategories = (Set)DefaultWikiMacroFactory.getDefaultCategories_aroundBody1$advice(this, defaultWikiMacroFactory = this, baseObject = macroDefinition, DefaultWikiMacroFactoryAspect.aspectOf(), baseObject, null)))) {
            macroDefaultCategories = Set.of();
            this.logger.debug("Incomplete macro definition in [{}], default macro category is empty", (Object)documentReference);
        }
        this.checkMacroCode(macroDefinition);
        List<WikiMacroParameterDescriptor> parameterDescriptors = this.buildParameterDescriptors(doc);
        ContentDescriptor contentDescriptor = this.getContentDescriptor(macroDefinition, documentReference);
        MacroId id = new MacroId(macroId);
        WikiMacroDescriptor macroDescriptor = new WikiMacroDescriptor.Builder().id(id).name(macroName).description(macroDescription).defaultCategories(macroDefaultCategories).visibility(macroVisibility).supportsInlineMode(macroSupportsInlineMode).contentDescriptor(contentDescriptor).parameterDescriptors(parameterDescriptors).build();
        DefaultWikiMacro wikiMacro = (DefaultWikiMacro)this.componentManager.getInstance(DefaultWikiMacro.class);
        wikiMacro.initialize(macroDefinition, (MacroDescriptor)macroDescriptor);
        return wikiMacro;
    }

    private ContentDescriptor getContentDescriptor(BaseObject macroDefinition, DocumentReference documentReference) {
        DefaultContentDescriptor contentDescriptor = null;
        String macroContentVisibility = (String)StringUtils.defaultIfEmpty((CharSequence)macroDefinition.getStringValue("contentType"), (CharSequence)"Optional");
        String macroContentDescription = macroDefinition.getStringValue("contentDescription");
        String macroContentJavaType = macroDefinition.getStringValue("contentJavaType");
        if (!macroContentVisibility.equals("No content") && StringUtils.isEmpty((CharSequence)macroContentDescription)) {
            this.logger.debug("Incomplete macro definition in [{}], macro content description is empty", (Object)documentReference);
            macroContentDescription = "Macro content";
        }
        if (!macroContentVisibility.equals("No content")) {
            Type contentType;
            if (StringUtils.isEmpty((CharSequence)macroContentJavaType) || "Unknown".equals(macroContentJavaType)) {
                contentType = DefaultContentDescriptor.DEFAULT_CONTENT_TYPE;
            } else if ("Wiki".equals(macroContentJavaType)) {
                contentType = Block.LIST_BLOCK_TYPE;
            } else {
                try {
                    contentType = ReflectionUtils.unserializeType((String)macroContentJavaType, (ClassLoader)this.getClass().getClassLoader());
                }
                catch (ClassNotFoundException e) {
                    this.logger.error("Error while unserializing macro content type [{}]. The default type will be used.", (Object)macroContentJavaType, (Object)e);
                    contentType = DefaultContentDescriptor.DEFAULT_CONTENT_TYPE;
                }
            }
            contentDescriptor = new DefaultContentDescriptor(macroContentDescription, macroContentVisibility.equals("Mandatory"), contentType);
        }
        return contentDescriptor;
    }

    private String getMacroId(BaseObject macroDefinition) {
        String macroId = macroDefinition.getStringValue("id");
        if (StringUtils.isEmpty((CharSequence)macroId)) {
            this.logger.debug("Incomplete macro definition in [{}], macro id is empty", (Object)macroDefinition.getReference());
            return null;
        }
        return macroId;
    }

    private String getMacroName(BaseObject macroDefinition, String macroId) {
        String macroName = macroDefinition.getStringValue("name");
        if (StringUtils.isEmpty((CharSequence)macroName)) {
            macroName = macroId;
            this.logger.debug("Incomplete macro definition in [{}], macro name is empty", (Object)macroDefinition.getReference());
        }
        return macroName;
    }

    private void checkMacroCode(BaseObject macroDefinition) throws WikiMacroException {
        String macroCode = macroDefinition.getStringValue("code");
        if (StringUtils.isEmpty((CharSequence)macroCode)) {
            throw new WikiMacroException(String.format("Incomplete macro definition in [%s], macro code is empty", macroDefinition.getReference()));
        }
    }

    private List<WikiMacroParameterDescriptor> buildParameterDescriptors(XWikiDocument doc) throws WikiMacroException {
        ArrayList<WikiMacroParameterDescriptor> parameterDescriptors = new ArrayList<WikiMacroParameterDescriptor>();
        List macroParameters = doc.getXObjects((EntityReference)WIKI_MACRO_PARAMETER_CLASS_REFERENCE);
        HashMap<List, PropertyGroupDescriptor> groupDescriptorMap = new HashMap<List, PropertyGroupDescriptor>();
        if (macroParameters != null) {
            for (BaseObject macroParameter : macroParameters) {
                Type parameterType;
                if (null == macroParameter) continue;
                String parameterName = macroParameter.getStringValue("name");
                String parameterDescription = macroParameter.getStringValue("description");
                boolean parameterMandatory = macroParameter.getIntValue("mandatory") != 0;
                String parameterDefaultValue = macroParameter.getStringValue("defaultValue");
                String type = macroParameter.getStringValue("type");
                if (StringUtils.isEmpty((CharSequence)type) || "Unknown".equals(type)) {
                    parameterType = DefaultParameterDescriptor.DEFAULT_PARAMETER_TYPE;
                } else if ("Wiki".equals(type)) {
                    parameterType = Block.LIST_BLOCK_TYPE;
                } else {
                    try {
                        parameterType = ReflectionUtils.unserializeType((String)type, (ClassLoader)Thread.currentThread().getContextClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        this.logger.error("Error while unserializing macro parameter type [{}]. The default type will be used.", (Object)type, (Object)e);
                        parameterType = DefaultParameterDescriptor.DEFAULT_PARAMETER_TYPE;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)parameterName)) {
                    throw new WikiMacroException(String.format("Incomplete macro definition in [%s], macro parameter name is empty", doc.getDocumentReference()));
                }
                if (StringUtils.isEmpty((CharSequence)parameterDescription)) {
                    this.logger.debug("Incomplete macro definition in [{}], macro parameter description is empty", (Object)doc.getDocumentReference());
                }
                if (StringUtils.isEmpty((CharSequence)parameterDefaultValue)) {
                    parameterDefaultValue = null;
                }
                List groupProperties = macroParameter.getListValue("group");
                PropertyGroupDescriptor groupDescriptor = null;
                if (!groupProperties.isEmpty() && groupDescriptorMap.containsKey(groupProperties)) {
                    groupDescriptor = (PropertyGroupDescriptor)groupDescriptorMap.get(groupProperties);
                } else if (!groupProperties.isEmpty()) {
                    groupDescriptor = new PropertyGroupDescriptor(groupProperties);
                    groupDescriptorMap.put(groupProperties, groupDescriptor);
                }
                String featureProperty = macroParameter.getStringValue("feature");
                if (!StringUtils.isEmpty((CharSequence)featureProperty)) {
                    if (groupDescriptor == null) {
                        groupDescriptor = new PropertyGroupDescriptor(null);
                    }
                    groupDescriptor.setFeature(featureProperty);
                    groupDescriptor.setFeatureMandatory(macroParameter.getIntValue("featureMandatory") != 0);
                }
                HashMap<String, Boolean> parametersMap = new HashMap<String, Boolean>(Map.of("advanced", macroParameter.getIntValue("advanced") != 0, "hidden", macroParameter.getIntValue("hidden") != 0, "deprecated", macroParameter.getIntValue("deprecated") != 0));
                if (groupDescriptor != null) {
                    parametersMap.put("group", (Boolean)groupDescriptor);
                }
                WikiMacroParameterDescriptor wikiMacroParameterDescriptor = new WikiMacroParameterDescriptor(parameterName, parameterDescription, parameterMandatory, (Object)parameterDefaultValue, parameterType, parametersMap);
                parameterDescriptors.add(wikiMacroParameterDescriptor);
            }
        }
        return parameterDescriptors;
    }

    public boolean containsWikiMacro(DocumentReference documentReference) {
        boolean result;
        try {
            XWikiDocument doc = this.getContext().getWiki().getDocument(documentReference, this.getContext());
            BaseObject macroDefinition = doc.getXObject((EntityReference)WIKI_MACRO_CLASS_REFERENCE);
            result = null != macroDefinition;
        }
        catch (XWikiException ex) {
            result = false;
        }
        return result;
    }

    public boolean isAllowed(DocumentReference documentReference, WikiMacroVisibility visibility) {
        DocumentReference authorReference;
        XWikiDocument doc;
        boolean isAllowed = false;
        XWikiContext xcontext = this.getContext();
        try {
            doc = xcontext.getWiki().getDocument(documentReference, this.getContext());
            authorReference = doc.getAuthorReference();
        }
        catch (XWikiException e) {
            this.logger.error("Failed to get document", (Throwable)e);
            doc = null;
            authorReference = null;
        }
        switch (visibility) {
            case GLOBAL: {
                isAllowed = doc != null && this.authorization.hasAccess(Right.PROGRAM, null, authorReference, documentReference);
                break;
            }
            case WIKI: {
                isAllowed = doc != null && this.authorization.hasAccess(Right.ADMIN, EntityType.WIKI, authorReference, documentReference);
                break;
            }
            default: {
                isAllowed = true;
            }
        }
        return isAllowed;
    }

    private Set<String> getDefaultCategories(BaseObject macroDefinition) {
        return macroDefinition.getSetValue("defaultCategories");
    }

    private static final /* synthetic */ Object getDefaultCategories_aroundBody1$advice(DefaultWikiMacroFactory ajc$this, DefaultWikiMacroFactory target, BaseObject macroDefinition, DefaultWikiMacroFactoryAspect ajc$aspectInstance, BaseObject macroDefinition2, AroundClosure ajc$aroundClosure) {
        AroundClosure aroundClosure = ajc$aroundClosure;
        BaseObject baseObject = macroDefinition2;
        Set<Object> defaultCategories = target.getDefaultCategories(baseObject);
        if (CollectionUtils.isEmpty((Collection)defaultCategories)) {
            String stringValue = macroDefinition2.getStringValue("defaultCategory");
            defaultCategories = stringValue != null ? Set.of(stringValue) : Set.of();
        }
        return defaultCategories;
    }
}

