/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimacro.internal;

import com.xpn.xwiki.objects.BaseObject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.component.wiki.internal.AbstractAsyncContentBaseObjectWikiComponent;
import org.xwiki.rendering.async.internal.AsyncRendererConfiguration;
import org.xwiki.rendering.async.internal.block.BlockAsyncRenderer;
import org.xwiki.rendering.block.AbstractBlock;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.CompositeBlock;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.internal.macro.script.NestedScriptMacroEnabled;
import org.xwiki.rendering.macro.Macro;
import org.xwiki.rendering.macro.MacroContentParser;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.MacroPreparationException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.MacroDescriptor;
import org.xwiki.rendering.macro.descriptor.ParameterDescriptor;
import org.xwiki.rendering.macro.parameter.MacroParameterException;
import org.xwiki.rendering.macro.wikibridge.WikiMacro;
import org.xwiki.rendering.macro.wikibridge.WikiMacroParameters;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.wikimacro.internal.DefaultWikiMacroRenderer;
import org.xwiki.rendering.wikimacro.internal.WikiMacroConstants;

@Component(roles={DefaultWikiMacro.class})
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DefaultWikiMacro
extends AbstractAsyncContentBaseObjectWikiComponent
implements WikiMacro,
NestedScriptMacroEnabled,
WikiMacroConstants {
    public static final String ATTRIBUTE_PREPARE_BLOCK_ID = "org.xwiki.rendering.wikimacro.internal.DefaultWikiMacro#BLOCK_ID";
    @Inject
    private MacroContentParser contentParser;
    private MacroDescriptor descriptor;
    private int macroPriority;
    private boolean executionIsolated;

    void initialize(BaseObject baseObject, MacroDescriptor descriptor) throws WikiComponentException {
        super.initialize(baseObject, Macro.class, descriptor.getId().getId());
        this.descriptor = descriptor;
        this.macroPriority = baseObject.getIntValue("priority", 1000);
        this.executionIsolated = baseObject.getIntValue("executionIsolated", 0) == 1;
    }

    protected String getContentPropertyName() {
        return "code";
    }

    public List<Block> execute(WikiMacroParameters parameters, String macroContent, MacroTransformationContext context) throws MacroExecutionException {
        Block result;
        DefaultWikiMacroRenderer renderer;
        try {
            renderer = (DefaultWikiMacroRenderer)((Object)this.componentManager.getInstance(DefaultWikiMacroRenderer.class));
        }
        catch (ComponentLookupException e) {
            throw new MacroExecutionException("Failed to create wiki macro rendeder", (Throwable)e);
        }
        this.validate(parameters, macroContent);
        renderer.initialize(this, parameters, macroContent, context);
        AsyncRendererConfiguration configuration = new AsyncRendererConfiguration();
        configuration.setSecureReference(this.getDocumentReference(), this.getAuthorReference());
        configuration.setContextEntries(this.contextEntries);
        try {
            result = this.executor.execute((BlockAsyncRenderer)renderer, configuration);
        }
        catch (Exception e) {
            throw new MacroExecutionException("Failed to execute wiki macro", (Throwable)e);
        }
        return result instanceof CompositeBlock ? result.getChildren() : Arrays.asList(result);
    }

    public void prepare(MacroBlock macroBlock) throws MacroPreparationException {
        this.prepareContent(macroBlock);
        this.prepareBlockId(macroBlock);
    }

    private void prepareContent(MacroBlock macroBlock) throws MacroPreparationException {
        ContentDescriptor contentDescriptor;
        if (macroBlock.getContent() != null && (contentDescriptor = this.getDescriptor().getContentDescriptor()) != null && contentDescriptor.getType().equals(Block.LIST_BLOCK_TYPE)) {
            this.contentParser.prepareContentWiki(macroBlock);
        }
    }

    private void prepareBlockId(MacroBlock macroBlock) {
        if (!this.isAsyncAllowed() && !this.isCacheAllowed()) {
            macroBlock.setAttribute(ATTRIBUTE_PREPARE_BLOCK_ID, this.getFastBlockId(macroBlock));
        }
    }

    public Object getBlockId(MacroBlock macroBlock) {
        Block rootBlock;
        Object cachedIndex = macroBlock.getAttribute(ATTRIBUTE_PREPARE_BLOCK_ID);
        if (cachedIndex != null) {
            return cachedIndex;
        }
        Object index = null;
        if ((this.isAsyncAllowed() || this.isCacheAllowed()) && (rootBlock = macroBlock.getRoot()) instanceof AbstractBlock) {
            AbstractBlock abstractblock = (AbstractBlock)rootBlock;
            index = abstractblock.indexOf((Block)macroBlock);
        }
        if (index == null) {
            index = this.getFastBlockId(macroBlock);
        }
        macroBlock.setAttribute(ATTRIBUTE_PREPARE_BLOCK_ID, index);
        return index;
    }

    public Object getFastBlockId(MacroBlock macroBlock) {
        return UUID.randomUUID().toString();
    }

    private void validate(WikiMacroParameters parameters, String macroContent) throws MacroExecutionException {
        Map parameterDescriptors = this.getDescriptor().getParameterDescriptorMap();
        for (ParameterDescriptor parameterDescriptor : parameterDescriptors.values()) {
            Object parameterValue = parameters.get(parameterDescriptor.getId());
            if (parameterDescriptor.isMandatory() && null == parameterValue) {
                throw new MacroParameterException(String.format("Parameter [%s] is mandatory", parameterDescriptor.getId()));
            }
            Object parameterDefaultValue = parameterDescriptor.getDefaultValue();
            if (parameterValue != null || parameterDefaultValue == null) continue;
            parameters.set(parameterDescriptor.getId(), parameterDefaultValue);
        }
        if (this.getDescriptor().getContentDescriptor() != null && this.getDescriptor().getContentDescriptor().isMandatory() && (macroContent == null || macroContent.length() == 0)) {
            throw new MacroExecutionException("Missing macro content: this macro requires content (a body)");
        }
    }

    public MacroDescriptor getDescriptor() {
        return this.descriptor;
    }

    public int getPriority() {
        return this.macroPriority;
    }

    public String getId() {
        return this.getRoleHint();
    }

    public int compareTo(Macro<?> macro) {
        return this.getPriority() - macro.getPriority();
    }

    public boolean supportsInlineMode() {
        return this.descriptor.supportsInlineMode();
    }

    boolean isAsyncAllowed() {
        return this.asyncAllowed;
    }

    boolean isCacheAllowed() {
        return this.cacheAllowed;
    }

    public boolean isExecutionIsolated(WikiMacroParameters parameters, String content) {
        return this.executionIsolated;
    }
}

