/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.macro.wikibridge;

import java.lang.reflect.Type;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.properties.PropertyGroupDescriptor;
import org.xwiki.rendering.macro.descriptor.ParameterDescriptor;
import org.xwiki.stability.Unstable;
import org.xwiki.text.XWikiToStringBuilder;

public class WikiMacroParameterDescriptor
implements ParameterDescriptor {
    @Unstable
    public static final String ADVANCED_PARAMETER_NAME = "advanced";
    @Unstable
    public static final String HIDDEN_PARAMETER_NAME = "hidden";
    @Unstable
    public static final String DEPRECATED_PARAMETER_NAME = "deprecated";
    @Unstable
    public static final String GROUP_PARAMETER_NAME = "group";
    private final String id;
    private final String description;
    private final boolean mandatory;
    private final Object defaultValue;
    private final Type parameterType;
    private final boolean advanced;
    private final boolean displayHidden;
    private final boolean deprecated;
    private final PropertyGroupDescriptor groupDescriptor;

    public WikiMacroParameterDescriptor(String id, String description, boolean mandatory) {
        this(id, description, mandatory, null);
    }

    public WikiMacroParameterDescriptor(String id, String description, boolean mandatory, Object defaultValue) {
        this(id, description, mandatory, defaultValue, null);
    }

    public WikiMacroParameterDescriptor(String id, String description, boolean mandatory, Object defaultValue, Type parameterType) {
        this(id, description, mandatory, defaultValue, parameterType, Map.of());
    }

    @Unstable
    public WikiMacroParameterDescriptor(String id, String description, boolean mandatory, Object defaultValue, Type parameterType, Map<String, Object> parameters) {
        PropertyGroupDescriptor localGroupDescriptor;
        this.id = id;
        this.description = description;
        this.mandatory = mandatory;
        this.defaultValue = defaultValue;
        this.parameterType = parameterType;
        this.advanced = Boolean.parseBoolean(String.valueOf(parameters.get(ADVANCED_PARAMETER_NAME)));
        this.displayHidden = Boolean.parseBoolean(String.valueOf(parameters.get(HIDDEN_PARAMETER_NAME)));
        this.deprecated = Boolean.parseBoolean(String.valueOf(parameters.get(DEPRECATED_PARAMETER_NAME)));
        Object object = parameters.get(GROUP_PARAMETER_NAME);
        this.groupDescriptor = object instanceof PropertyGroupDescriptor ? (localGroupDescriptor = (PropertyGroupDescriptor)object) : null;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    @Deprecated
    public Class<?> getType() {
        Class<String> type = ReflectionUtils.getTypeClass((Type)this.parameterType);
        if (type == null) {
            type = String.class;
        }
        return type;
    }

    public Type getParameterType() {
        if (this.parameterType != null) {
            return this.parameterType;
        }
        return this.getType();
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public boolean isDisplayHidden() {
        return this.displayHidden;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public PropertyGroupDescriptor getGroupDescriptor() {
        return this.groupDescriptor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WikiMacroParameterDescriptor that = (WikiMacroParameterDescriptor)o;
        return new EqualsBuilder().append(this.mandatory, that.mandatory).append(this.advanced, that.advanced).append(this.displayHidden, that.displayHidden).append(this.deprecated, that.deprecated).append((Object)this.id, (Object)that.id).append((Object)this.description, (Object)that.description).append(this.defaultValue, that.defaultValue).append((Object)this.groupDescriptor, (Object)that.groupDescriptor).append((Object)this.parameterType, (Object)that.parameterType).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 63).append((Object)this.id).append((Object)this.description).append(this.mandatory).append(this.defaultValue).append(this.advanced).append(this.displayHidden).append(this.deprecated).append((Object)this.groupDescriptor).append((Object)this.parameterType).toHashCode();
    }

    public String toString() {
        return new XWikiToStringBuilder((Object)this).append("id", (Object)this.id).append("description", (Object)this.description).append("mandatory", this.mandatory).append("defaultValue", this.defaultValue).append("parameterType", (Object)this.parameterType).append(ADVANCED_PARAMETER_NAME, this.advanced).append("displayHidden", this.displayHidden).append(DEPRECATED_PARAMETER_NAME, this.deprecated).append("groupDescriptor", (Object)this.groupDescriptor).toString();
    }
}

