/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.include;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.PageReference;
import org.xwiki.model.reference.PageReferenceResolver;
import org.xwiki.properties.BeanManager;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.listener.reference.AttachmentResourceReference;
import org.xwiki.rendering.listener.reference.DocumentResourceReference;
import org.xwiki.rendering.listener.reference.PageResourceReference;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.macro.MacroRefactoring;
import org.xwiki.rendering.macro.MacroRefactoringException;
import org.xwiki.rendering.macro.include.IncludeMacroParameters;
import org.xwiki.text.StringUtils;

@Component
@Singleton
@Named(value="include")
public class IncludeMacroRefactoring
implements MacroRefactoring {
    @Inject
    private Logger logger;
    @Inject
    @Named(value="compact")
    private EntityReferenceSerializer<String> compactEntityReferenceSerializer;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> compactWikiEntityReferenceSerializer;
    @Inject
    @Named(value="macro")
    private EntityReferenceResolver<String> macroEntityReferenceResolver;
    @Inject
    private EntityReferenceResolver<EntityReference> defaultEntityReferenceResolver;
    @Inject
    private BeanManager beanManager;
    @Inject
    private PageReferenceResolver<EntityReference> pageReferenceResolver;

    public Optional<MacroBlock> replaceReference(MacroBlock macroBlock, DocumentReference currentDocumentReference, DocumentReference sourceReference, DocumentReference targetReference, boolean relative, Map<EntityReference, EntityReference> updatedEntities) throws MacroRefactoringException {
        return this.getMacroBlock(macroBlock, currentDocumentReference, sourceReference, targetReference, relative, updatedEntities);
    }

    public Optional<MacroBlock> replaceReference(MacroBlock macroBlock, DocumentReference currentDocumentReference, AttachmentReference sourceReference, AttachmentReference targetReference, boolean relative, Map<EntityReference, EntityReference> updatedEntities) throws MacroRefactoringException {
        return this.getMacroBlock(macroBlock, currentDocumentReference, sourceReference, targetReference, relative, updatedEntities);
    }

    public Optional<MacroBlock> replaceReference(MacroBlock macroBlock, DocumentReference currentDocumentReference, DocumentReference sourceReference, DocumentReference targetReference, boolean relative) throws MacroRefactoringException {
        return this.getMacroBlock(macroBlock, currentDocumentReference, sourceReference, targetReference, relative, Map.of(sourceReference, targetReference));
    }

    public Optional<MacroBlock> replaceReference(MacroBlock macroBlock, DocumentReference currentDocumentReference, AttachmentReference sourceReference, AttachmentReference targetReference, boolean relative) throws MacroRefactoringException {
        return this.getMacroBlock(macroBlock, currentDocumentReference, sourceReference, targetReference, relative, Map.of(sourceReference.getDocumentReference(), targetReference.getDocumentReference()));
    }

    private <T extends EntityReference> Optional<MacroBlock> getMacroBlock(MacroBlock macroBlock, DocumentReference currentDocumentReference, T sourceReference, T targetReference, boolean relative, Map<EntityReference, EntityReference> updatedEntities) throws MacroRefactoringException {
        Optional<Object> result;
        IncludeMacroParameters parameters = this.getMacroParameters(macroBlock);
        if (!StringUtils.isEmpty((CharSequence)parameters.getReference())) {
            boolean serialized;
            EntityReference targetResolvedReference;
            boolean serialized2;
            boolean resolvedRelative;
            MacroBlock newMacroBlock = (MacroBlock)macroBlock.clone();
            EntityReference reference = this.macroEntityReferenceResolver.resolve((Object)parameters.getReference(), parameters.getType(), new Object[]{macroBlock, sourceReference});
            boolean bl = resolvedRelative = !this.isReferenceAbsolute(parameters.getReference(), reference);
            result = this.areReferencesEqual(reference, sourceReference) ? ((serialized2 = this.serializeTargetReference(reference, newMacroBlock, targetReference, (EntityReference)currentDocumentReference, resolvedRelative)) ? Optional.of(newMacroBlock) : Optional.empty()) : (!(reference = this.macroEntityReferenceResolver.resolve((Object)parameters.getReference(), parameters.getType(), new Object[]{macroBlock, sourceReference})).equals((Object)(targetResolvedReference = this.macroEntityReferenceResolver.resolve((Object)parameters.getReference(), parameters.getType(), new Object[]{macroBlock, targetReference}))) ? ((serialized = this.serializeTargetReference(reference, newMacroBlock, reference, targetResolvedReference, resolvedRelative)) ? Optional.of(newMacroBlock) : Optional.empty()) : Optional.empty());
        } else {
            result = Optional.empty();
        }
        return result;
    }

    public Set<ResourceReference> extractReferences(MacroBlock macroBlock) throws MacroRefactoringException {
        PageResourceReference resourceReference;
        IncludeMacroParameters parameters = this.getMacroParameters(macroBlock);
        if (EntityType.PAGE.equals((Object)parameters.getType())) {
            resourceReference = new PageResourceReference(parameters.getReference());
        } else if (EntityType.DOCUMENT.equals((Object)parameters.getType())) {
            resourceReference = new DocumentResourceReference(parameters.getReference());
        } else if (EntityType.ATTACHMENT.equals((Object)parameters.getType())) {
            resourceReference = new AttachmentResourceReference(parameters.getReference());
        } else {
            this.logger.warn("The reference type [{}] is not currently supported. Not extracting the reference [{}] for it.", (Object)parameters.getType(), (Object)parameters.getReference());
            resourceReference = null;
        }
        return resourceReference != null ? Collections.singleton(resourceReference) : Collections.emptySet();
    }

    private boolean areReferencesEqual(EntityReference reference1, EntityReference reference2) {
        boolean result;
        if (reference1.equals((Object)reference2)) {
            result = true;
        } else if (this.isPointingToDocuments(reference1, reference2) || this.isPointingToAttachments(reference1, reference2)) {
            EntityReference convertedReference2 = this.defaultEntityReferenceResolver.resolve((Object)reference2, reference1.getType(), new Object[0]);
            result = reference1.equals((Object)convertedReference2);
        } else {
            result = false;
        }
        return result;
    }

    private boolean isPointingToDocuments(EntityReference reference1, EntityReference reference2) {
        return !(!EntityType.DOCUMENT.equals((Object)reference1.getType()) && !EntityType.PAGE.equals((Object)reference1.getType()) || !EntityType.DOCUMENT.equals((Object)reference2.getType()) && !EntityType.PAGE.equals((Object)reference2.getType()));
    }

    private boolean isPointingToAttachments(EntityReference reference1, EntityReference reference2) {
        return !(!EntityType.ATTACHMENT.equals((Object)reference1.getType()) && !EntityType.PAGE_ATTACHMENT.equals((Object)reference1.getType()) || !EntityType.ATTACHMENT.equals((Object)reference2.getType()) && !EntityType.PAGE_ATTACHMENT.equals((Object)reference2.getType()));
    }

    private <T extends EntityReference> boolean serializeTargetReference(EntityReference originalReference, MacroBlock newMacroBlock, T targetReference, EntityReference currentReference, boolean relative) {
        boolean result;
        if (EntityType.PAGE.equals((Object)originalReference.getType())) {
            PageReference pageReference = this.pageReferenceResolver.resolve(targetReference, new Object[0]);
            newMacroBlock.setParameter("page", this.serializeTargetReference((EntityReference)pageReference, currentReference, relative));
            result = true;
        } else {
            newMacroBlock.setParameter("reference", this.serializeTargetReference(targetReference, currentReference, relative));
            result = true;
        }
        return result;
    }

    private String serializeTargetReference(EntityReference newTargetReference, EntityReference currentReference, boolean relative) {
        return relative ? (String)this.compactEntityReferenceSerializer.serialize(newTargetReference, new Object[]{currentReference}) : (String)this.compactWikiEntityReferenceSerializer.serialize(newTargetReference, new Object[]{currentReference.extractReference(EntityType.WIKI)});
    }

    private IncludeMacroParameters getMacroParameters(MacroBlock macroBlock) throws MacroRefactoringException {
        IncludeMacroParameters macroParameters = new IncludeMacroParameters();
        try {
            this.beanManager.populate((Object)macroParameters, macroBlock.getParameters());
        }
        catch (Throwable e) {
            throw new MacroRefactoringException(String.format("There's one or several invalid parameters for an [%s] macro with parameters [%s]", macroBlock.getId(), macroBlock.getParameters()), e);
        }
        return macroParameters;
    }

    private boolean isReferenceAbsolute(String referenceRepresentation, EntityReference absoluteEntityReference) {
        return ((String)this.compactWikiEntityReferenceSerializer.serialize(absoluteEntityReference, new Object[]{absoluteEntityReference.extractReference(EntityType.WIKI)})).equals(referenceRepresentation);
    }
}

