/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.internal.splitter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.refactoring.WikiDocument;
import org.xwiki.refactoring.splitter.DocumentSplitter;
import org.xwiki.refactoring.splitter.criterion.SplittingCriterion;
import org.xwiki.refactoring.splitter.criterion.naming.NamingCriterion;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.BlockFilter;
import org.xwiki.rendering.block.HeaderBlock;
import org.xwiki.rendering.block.IdBlock;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.block.NewLineBlock;
import org.xwiki.rendering.block.SectionBlock;
import org.xwiki.rendering.block.SpaceBlock;
import org.xwiki.rendering.block.SpecialSymbolBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.listener.reference.DocumentResourceReference;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;

@Component
@Singleton
public class DefaultDocumentSplitter
implements DocumentSplitter {
    private static final String ANCHOR_PARAMETER = "anchor";
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> compactWikiEntityReferenceSerializer;

    @Override
    public List<WikiDocument> split(WikiDocument rootDoc, SplittingCriterion splittingCriterion, NamingCriterion namingCriterion) {
        ArrayList<WikiDocument> result = new ArrayList<WikiDocument>();
        result.add(rootDoc);
        this.split(rootDoc, rootDoc.getXdom().getChildren(), 1, result, splittingCriterion, namingCriterion);
        this.updateAnchors(result);
        return result;
    }

    private void split(WikiDocument parentDoc, List<Block> children, int depth, List<WikiDocument> result, SplittingCriterion splittingCriterion, NamingCriterion namingCriterion) {
        ListIterator<Block> it = children.listIterator();
        while (it.hasNext()) {
            Block block = it.next();
            if (splittingCriterion.shouldSplit(block, depth)) {
                XDOM xdom = new XDOM(block.getChildren());
                DocumentReference newDocumentReference = namingCriterion.getDocumentReference(xdom);
                WikiDocument newDoc = new WikiDocument(newDocumentReference, xdom, parentDoc);
                result.add(newDoc);
                it.remove();
                it.add((Block)new NewLineBlock());
                it.add((Block)this.createLink(block, (String)this.compactWikiEntityReferenceSerializer.serialize((EntityReference)newDocumentReference, new Object[]{parentDoc.getDocumentReference()})));
                if (!splittingCriterion.shouldIterate(block, depth)) continue;
                this.split(newDoc, newDoc.getXdom().getChildren(), depth + 1, result, splittingCriterion, namingCriterion);
                continue;
            }
            if (!splittingCriterion.shouldIterate(block, depth)) continue;
            this.split(parentDoc, block.getChildren(), depth + 1, result, splittingCriterion, namingCriterion);
        }
    }

    private LinkBlock createLink(Block block, String target) {
        Block firstBlock = (Block)block.getChildren().get(0);
        if (firstBlock instanceof HeaderBlock) {
            DocumentResourceReference reference = new DocumentResourceReference(target);
            Block clonedHeaderBlock = firstBlock.clone(new BlockFilter(){

                public List<Block> filter(Block block) {
                    ArrayList<Block> blocks = new ArrayList<Block>();
                    if (block instanceof WordBlock || block instanceof SpaceBlock || block instanceof SpecialSymbolBlock) {
                        blocks.add(block);
                    }
                    return blocks;
                }
            });
            return new LinkBlock(clonedHeaderBlock.getChildren(), (ResourceReference)reference, false);
        }
        if (firstBlock instanceof SectionBlock) {
            return this.createLink(firstBlock, target);
        }
        throw new IllegalArgumentException("A SectionBlock should either begin with a HeaderBlock or another SectionBlock.");
    }

    private void updateAnchors(List<WikiDocument> documents) {
        Map<String, DocumentReference> fragments = this.collectDocumentFragments(documents);
        for (WikiDocument document : documents) {
            this.updateAnchors(document, fragments);
        }
    }

    private boolean isDocument(ResourceType resourceType) {
        return ResourceType.DOCUMENT.equals((Object)resourceType) || ResourceType.SPACE.equals((Object)resourceType) || ResourceType.PAGE.equals((Object)resourceType);
    }

    private void updateAnchors(WikiDocument document, Map<String, DocumentReference> fragments) {
        for (LinkBlock linkBlock : document.getXdom().getBlocks((BlockMatcher)new ClassBlockMatcher(LinkBlock.class), Block.Axes.DESCENDANT)) {
            DocumentReference targetDocumentReference;
            ResourceReference reference = linkBlock.getReference();
            ResourceType resoureceType = reference.getType();
            String fragment = null;
            if (this.isDocument(resoureceType) && StringUtils.isEmpty((CharSequence)reference.getReference())) {
                fragment = reference.getParameter(ANCHOR_PARAMETER);
            } else if (Strings.CS.startsWith((CharSequence)reference.getReference(), (CharSequence)"#") && (ResourceType.PATH.equals((Object)resoureceType) || ResourceType.URL.equals((Object)resoureceType))) {
                fragment = reference.getReference().substring(1);
            }
            if ((targetDocumentReference = fragments.get(fragment)) == null || targetDocumentReference.equals((Object)document.getDocumentReference())) continue;
            reference.setType(ResourceType.DOCUMENT);
            reference.setReference((String)this.compactWikiEntityReferenceSerializer.serialize((EntityReference)targetDocumentReference, new Object[]{document.getDocumentReference()}));
            reference.setParameter(ANCHOR_PARAMETER, fragment);
        }
    }

    private Map<String, DocumentReference> collectDocumentFragments(List<WikiDocument> documents) {
        HashMap<String, DocumentReference> fragments = new HashMap<String, DocumentReference>();
        for (WikiDocument document : documents) {
            for (IdBlock idBlock : document.getXdom().getBlocks((BlockMatcher)new ClassBlockMatcher(IdBlock.class), Block.Axes.DESCENDANT)) {
                fragments.put(idBlock.getName(), document.getDocumentReference());
            }
        }
        return fragments;
    }
}

