/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.internal.listener;

import java.time.Instant;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.IntSupplier;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.refactoring.internal.listener.LinkIndexingQuestion;

public class LinkIndexingQuestionHandler {
    private final ExecutorService executor;
    private final int timeout;
    private final TimeUnit unit;
    private final IntSupplier progressSupplier;
    private Future<Void> questionFuture;
    private LinkIndexingQuestion question;
    private final JobStatus jobStatus;
    private final Instant startTime;

    public LinkIndexingQuestionHandler(int timeout, TimeUnit unit, IntSupplier progressSupplier, JobStatus jobStatus, ExecutorService executor) {
        this.executor = executor;
        this.jobStatus = jobStatus;
        this.timeout = timeout;
        this.unit = unit;
        this.progressSupplier = progressSupplier;
        this.startTime = Instant.now();
    }

    public boolean shallContinueWaiting() throws ExecutionException, InterruptedException {
        if (this.question == null && this.progressSupplier.getAsInt() < 75 && this.startTime.plus((long)this.timeout, this.unit.toChronoUnit()).isBefore(Instant.now())) {
            this.question = new LinkIndexingQuestion();
            this.questionFuture = this.executor.submit(() -> {
                this.jobStatus.ask((Object)this.question);
                return null;
            });
        }
        if (this.questionFuture != null && this.questionFuture.isDone() && this.question != null) {
            this.questionFuture.get();
            this.questionFuture = null;
            return this.question.isContinueWaiting();
        }
        return true;
    }

    public void cancelPendingQuestion() {
        if (this.questionFuture != null && !this.questionFuture.isDone()) {
            this.jobStatus.answered();
        }
    }
}

