/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.internal.job;

import java.util.Collection;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.Request;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.refactoring.RefactoringConfiguration;
import org.xwiki.refactoring.batch.BatchOperationExecutor;
import org.xwiki.refactoring.internal.job.AbstractEntityJob;
import org.xwiki.refactoring.internal.job.AbstractEntityJobWithChecks;
import org.xwiki.refactoring.job.DeleteRequest;
import org.xwiki.refactoring.job.EntityJobStatus;
import org.xwiki.refactoring.job.question.EntitySelection;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="refactoring/delete")
public class DeleteJob
extends AbstractEntityJobWithChecks<DeleteRequest, EntityJobStatus<DeleteRequest>> {
    @Inject
    private BatchOperationExecutor batchOperationExecutor;
    @Inject
    private RefactoringConfiguration configuration;
    @Inject
    private DocumentAccessBridge documentAccessBridge;

    protected DeleteRequest castRequest(Request request) {
        return new DeleteRequest(request);
    }

    public String getType() {
        return "refactoring/delete";
    }

    @Override
    protected void getEntities(Collection<EntityReference> entityReferences) {
        super.getEntities(entityReferences);
        this.notifyDocumentsDeleting();
    }

    @Override
    protected void process(Collection<EntityReference> entityReferences) {
        this.batchOperationExecutor.execute(() -> super.process(entityReferences));
    }

    @Override
    protected void process(EntityReference entityReference) {
        switch (entityReference.getType()) {
            case DOCUMENT: {
                try {
                    this.process(new DocumentReference(entityReference));
                }
                catch (Exception e) {
                    this.logger.error("Failed to delete document with reference [{}]", (Object)entityReference, (Object)e);
                }
                break;
            }
            case SPACE: {
                this.process(new SpaceReference(entityReference));
                break;
            }
            default: {
                this.logger.error("Unsupported entity type [{}].", (Object)entityReference.getType());
            }
        }
    }

    private void process(DocumentReference documentReference) throws Exception {
        if (((DeleteRequest)this.request).isDeep() && this.isSpaceHomeReference(documentReference)) {
            this.process(documentReference.getLastSpaceReference());
        } else {
            this.maybeDelete(documentReference);
        }
    }

    private void process(final SpaceReference spaceReference) {
        this.visitDocuments(spaceReference, new AbstractEntityJob.Visitor<DocumentReference>(){

            @Override
            public void visit(DocumentReference documentReference) {
                try {
                    DeleteJob.this.maybeDelete(documentReference);
                }
                catch (Exception e) {
                    DeleteJob.this.logger.error("Failed to delete document [{}] from space [{}]", new Object[]{documentReference, spaceReference, e});
                }
            }
        });
    }

    private void maybeDelete(DocumentReference documentReference) throws Exception {
        boolean skipRecycleBin = this.configuration.isRecycleBinSkippingActivated() && this.documentAccessBridge.isAdvancedUser() && ((DeleteRequest)this.getRequest()).shouldSkipRecycleBin();
        EntitySelection entitySelection = this.getConcernedEntitiesEntitySelection((EntityReference)documentReference);
        if (entitySelection == null) {
            this.logger.info("Skipping [{}] because it does not match any entity selection.", (Object)documentReference);
        } else if (!entitySelection.isSelected()) {
            this.logger.info("Skipping [{}] because it has been unselected.", (Object)documentReference);
        } else if (!this.modelBridge.exists(documentReference)) {
            this.logger.warn("Skipping [{}] because it doesn't exist.", (Object)documentReference);
        } else if (!this.hasAccess(Right.DELETE, (EntityReference)documentReference)) {
            this.logger.error("You are not allowed to delete [{}].", (Object)documentReference);
        } else if (!skipRecycleBin) {
            this.delete(documentReference, false, "[{}] has been successfully moved to the recycle bin.");
        } else {
            this.delete(documentReference, true, "[{}] has been successfully deleted.");
        }
    }

    private void delete(DocumentReference documentReference, boolean skipRecycleBin, String logMessage) {
        this.modelBridge.delete(documentReference, skipRecycleBin);
        this.logger.debug(logMessage, (Object)documentReference);
        DocumentReference backlinkDocumentReference = documentReference;
        if (documentReference.getLocale() == Locale.ROOT) {
            backlinkDocumentReference = new DocumentReference((EntityReference)documentReference, (Locale)null);
        }
        DocumentReference newTarget = ((DeleteRequest)this.getRequest()).getNewBacklinkTargets().get(backlinkDocumentReference);
        if (((DeleteRequest)this.getRequest()).isAutoRedirect() && newTarget != null) {
            if (((DeleteRequest)this.getRequest()).isVerbose()) {
                this.logger.info("Creating automatic redirect from [{}] to [{}].", (Object)documentReference, (Object)newTarget);
            }
            this.modelBridge.createRedirect(documentReference, newTarget);
        }
    }
}

