/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.internal.job;

import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.refactoring.internal.job.AbstractEntityJob;
import org.xwiki.refactoring.job.CreateRequest;
import org.xwiki.refactoring.job.EntityJobStatus;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="refactoring/create")
public class CreateJob
extends AbstractEntityJob<CreateRequest, EntityJobStatus<CreateRequest>> {
    public String getType() {
        return "refactoring/create";
    }

    @Override
    protected void process(EntityReference entityReference) {
        switch (entityReference.getType()) {
            case DOCUMENT: {
                try {
                    this.process(new DocumentReference(entityReference));
                }
                catch (Exception e) {
                    this.logger.error("Failed to create document with reference [{}]", (Object)entityReference, (Object)e);
                }
                break;
            }
            case SPACE: {
                this.process(new SpaceReference(entityReference));
                break;
            }
            default: {
                this.logger.error("Unsupported entity type [{}].", (Object)entityReference.getType());
            }
        }
    }

    private void process(DocumentReference documentReference) throws Exception {
        DocumentReference templateDocumentReference = null;
        if (((CreateRequest)this.request).getTemplateReference() != null && ((CreateRequest)this.request).getTemplateReference().extractReference(EntityType.DOCUMENT) != null) {
            templateDocumentReference = new DocumentReference(((CreateRequest)this.request).getTemplateReference().extractReference(EntityType.DOCUMENT));
        }
        this.progressManager.pushLevelProgress(3, (Object)this);
        try {
            this.progressManager.startStep((Object)this, "Main document");
            this.maybeCreate(documentReference, templateDocumentReference);
            this.progressManager.startStep((Object)this, "Template children");
            if (((CreateRequest)this.request).isDeep() && this.isSpaceHomeReference(documentReference) && templateDocumentReference != null && this.isSpaceHomeReference(templateDocumentReference)) {
                this.process(documentReference.getLastSpaceReference());
            }
            this.progressManager.startStep((Object)this, "Remove lock from the main document");
            this.modelBridge.removeLock(documentReference);
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    private void process(final SpaceReference newSpaceReference) {
        SpaceReference templateSpaceReference;
        SpaceReference extractedSpaceReference = null;
        if (((CreateRequest)this.request).getTemplateReference() != null && ((CreateRequest)this.request).getTemplateReference().extractReference(EntityType.SPACE) != null) {
            extractedSpaceReference = new SpaceReference(((CreateRequest)this.request).getTemplateReference().extractReference(EntityType.SPACE));
        }
        if ((templateSpaceReference = extractedSpaceReference) != null) {
            this.visitDocuments(templateSpaceReference, new AbstractEntityJob.Visitor<DocumentReference>(){

                @Override
                public void visit(DocumentReference templateDocumentReference) {
                    DocumentReference newDocumentReference = templateDocumentReference.replaceParent((EntityReference)templateSpaceReference, (EntityReference)newSpaceReference);
                    try {
                        CreateJob.this.maybeCreate(newDocumentReference, templateDocumentReference);
                    }
                    catch (Exception e) {
                        CreateJob.this.logger.error("Failed to create document with reference [{}] and template [{}]", new Object[]{newDocumentReference, templateDocumentReference, e});
                    }
                }
            });
        } else {
            DocumentReference newSpaceWebHomeReference = new DocumentReference("WebHome", newSpaceReference);
            try {
                this.maybeCreate(newSpaceWebHomeReference, null);
            }
            catch (Exception e) {
                this.logger.error("Failed to create home page for space with reference [{}]", (Object)newSpaceReference, (Object)e);
            }
        }
    }

    private void maybeCreate(DocumentReference newDocumentReference, DocumentReference templateDocumentReference) throws Exception {
        if (((CreateRequest)this.request).getSkippedEntities().contains(newDocumentReference)) {
            this.logger.debug("Skipping creation of document [{}], as specified in the request.", (Object)newDocumentReference);
        } else if (this.modelBridge.exists(newDocumentReference) && !this.modelBridge.canOverwriteSilently(newDocumentReference)) {
            this.logger.warn("Skipping creation of document [{}] because it already exists.", (Object)newDocumentReference);
        } else if (!this.hasAccess(Right.EDIT, (EntityReference)newDocumentReference)) {
            this.logger.error("You are not allowed to create the document [{}].", (Object)newDocumentReference);
        } else if (templateDocumentReference == null) {
            this.modelBridge.create(newDocumentReference);
        } else if (!this.hasAccess(Right.VIEW, (EntityReference)templateDocumentReference)) {
            this.logger.error("You are not allowed to view the template document [{}].", (Object)templateDocumentReference);
        } else if (!this.modelBridge.exists(templateDocumentReference)) {
            this.logger.error("Template document [{}] does not exist.", (Object)templateDocumentReference);
        } else {
            this.modelBridge.copy(templateDocumentReference, newDocumentReference);
        }
    }
}

