/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.internal.job;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.refactoring.internal.job.AbstractEntityJob;
import org.xwiki.refactoring.job.EntityJobStatus;
import org.xwiki.refactoring.job.ReplaceUserRequest;
import org.xwiki.security.authorization.Right;

public abstract class AbstractReplaceUserJob
extends AbstractEntityJob<ReplaceUserRequest, EntityJobStatus<ReplaceUserRequest>> {
    @Inject
    private QueryManager queryManager;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> compactWikiEntityReferenceSerializer;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;

    public String getType() {
        return "refactoring/replaceUser";
    }

    @Override
    protected void runInternal() throws Exception {
        DocumentReference newUserReference;
        DocumentReference oldUserReference = ((ReplaceUserRequest)this.getRequest()).getOldUserReference();
        if (!Objects.equals(oldUserReference, newUserReference = ((ReplaceUserRequest)this.getRequest()).getNewUserReference()) && this.isSomethingToReplace()) {
            if (oldUserReference != null && newUserReference != null) {
                super.runInternal();
            } else {
                this.logger.error("Replacing the guest user is not supported.");
            }
        }
    }

    private boolean isSomethingToReplace() {
        return ((ReplaceUserRequest)this.getRequest()).isReplaceDocumentAuthor() || ((ReplaceUserRequest)this.getRequest()).isReplaceDocumentContentAuthor() || ((ReplaceUserRequest)this.getRequest()).isReplaceDocumentCreator();
    }

    @Override
    protected void process(EntityReference entityReference) {
        if (this.hasAccess(Right.ADMIN, entityReference)) {
            this.update(this.getDocumentsToUpdate(entityReference));
        } else {
            this.logger.error("You need administration right on [{}] in order to be able to replace the user.", (Object)entityReference);
        }
    }

    private List<DocumentReference> getDocumentsToUpdate(EntityReference entityReference) {
        if (entityReference.getType() != EntityType.WIKI && entityReference.getType() != EntityType.SPACE) {
            this.logger.warn("Skipping unsupported entity [{}].", (Object)entityReference);
            return Collections.emptyList();
        }
        try {
            this.logger.info("Updating documents from [{}].", (Object)entityReference);
            return this.getDocumentsToUpdateQuery(entityReference).execute().stream().map(this.resolveDocumentReferenceWithLocale(entityReference)).collect(Collectors.toList());
        }
        catch (QueryException e) {
            this.logger.error("Failed to retrieve the list of documents to update from [{}]. Root cause is [{}].", (Object)entityReference, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return Collections.emptyList();
        }
    }

    private Query getDocumentsToUpdateQuery(EntityReference parentReference) throws QueryException {
        ArrayList<String> oldUserConstraints = new ArrayList<String>();
        if (((ReplaceUserRequest)this.getRequest()).isReplaceDocumentAuthor()) {
            oldUserConstraints.add("doc.author = :oldUser");
        }
        if (((ReplaceUserRequest)this.getRequest()).isReplaceDocumentContentAuthor()) {
            oldUserConstraints.add("doc.contentAuthor = :oldUser");
        }
        if (((ReplaceUserRequest)this.getRequest()).isReplaceDocumentCreator()) {
            oldUserConstraints.add("doc.creator = :oldUser");
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("oldUser", (String)this.compactWikiEntityReferenceSerializer.serialize((EntityReference)((ReplaceUserRequest)this.getRequest()).getOldUserReference(), new Object[]{parentReference}));
        ArrayList<Object> constraints = new ArrayList<Object>();
        constraints.add("(" + StringUtils.join(oldUserConstraints, (String)" OR ") + ")");
        EntityReference spaceReference = parentReference.extractReference(EntityType.SPACE);
        if (spaceReference != null) {
            constraints.add("doc.space = :space");
            parameters.put("space", (String)this.compactWikiEntityReferenceSerializer.serialize(spaceReference, new Object[]{parentReference}));
        }
        String statement = "select doc.fullName, doc.language from XWikiDocument as doc where " + StringUtils.join(constraints, (String)" AND ");
        Query query = this.queryManager.createQuery(statement, "hql");
        query.setWiki(parentReference.extractReference(EntityType.WIKI).getName());
        for (Map.Entry entry : parameters.entrySet()) {
            query.bindValue((String)entry.getKey(), entry.getValue());
        }
        return query;
    }

    private Function<Object[], DocumentReference> resolveDocumentReferenceWithLocale(EntityReference parentReference) {
        return result -> new DocumentReference((EntityReference)this.documentReferenceResolver.resolve((Object)((String)result[0]), new Object[]{parentReference}), LocaleUtils.toLocale((String)((String)result[1])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(List<DocumentReference> documentReferences) {
        this.progressManager.pushLevelProgress(documentReferences.size(), (Object)this);
        try {
            for (DocumentReference documentReference : documentReferences) {
                if (((EntityJobStatus)this.status).isCanceled()) {
                    break;
                }
                this.progressManager.startStep((Object)this);
                this.logger.info("Updating document [{}].", (Object)documentReference);
                this.update(documentReference);
                this.progressManager.endStep((Object)this);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    protected abstract void update(DocumentReference var1);
}

