/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.hibernate.internal;

import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hibernate.Session;
import org.hibernate.boot.Metadata;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.query.NativeQuery;
import org.xwiki.component.annotation.Component;
import org.xwiki.store.hibernate.AbstractHibernateAdapter;
import org.xwiki.store.hibernate.HibernateStoreException;

@Component
@Named(value="oracle")
@Singleton
public class OracleHibernateAdapter
extends AbstractHibernateAdapter {
    public static final String HINT = "oracle";

    @Override
    public void updateDatabaseAfter(Metadata metadata, Session session) throws HibernateStoreException {
        if (this.isCompressionAllowed()) {
            this.updateTableCompression(metadata, session);
        }
    }

    private void updateTableCompression(Metadata metadata, Session session) {
        Set<String> compressedTables = this.getCompressedTables(session);
        for (PersistentClass entity : metadata.getEntityBindings()) {
            String tableName = this.getTableName(entity);
            boolean compressed = this.isCompressed(entity);
            if (compressedTables.contains(tableName) == compressed) continue;
            NativeQuery query = session.createNativeQuery("ALTER TABLE " + tableName + " " + (compressed ? "COMPRESS" : "NOCOMPRESS"));
            session.getTransaction().begin();
            query.executeUpdate();
            session.getTransaction().commit();
        }
    }

    public Set<String> getCompressedTables(Session session) {
        NativeQuery query = session.createNativeQuery("SELECT DISTINCT table_name FROM user_tables WHERE compression = 'ENABLED'");
        return query.list().stream().map(String::toUpperCase).collect(Collectors.toSet());
    }

    @Override
    public String getTableName(String tableName) {
        return tableName != null ? tableName.toUpperCase() : null;
    }

    @Override
    protected String cleanDatabaseName(String name) {
        return super.cleanDatabaseName(name).toUpperCase();
    }

    @Override
    public String escapeDatabaseName(String databaseName) {
        return databaseName;
    }

    @Override
    public boolean isCatalog() {
        return false;
    }
}

