/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.hibernate.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.hibernate.boot.Metadata;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.query.NativeQuery;
import org.xwiki.component.annotation.Component;
import org.xwiki.store.hibernate.AbstractHibernateAdapter;
import org.xwiki.store.hibernate.HibernateStoreException;

@Component
@Singleton
@Named(value="mysql")
public class MySQLHibernateAdapter
extends AbstractHibernateAdapter {
    public static final String HINT = "mysql";

    @Override
    public void updateDatabaseAfter(Metadata metadata, Session session) throws HibernateStoreException {
        this.updateRowFormats(metadata, session);
    }

    protected void updateRowFormats(Metadata metadata, Session session) throws HibernateStoreException {
        Map<String, String> rowFormats = this.getRowFormats(session);
        boolean compressionAllowed = this.isCompressionAllowed();
        for (PersistentClass entity : metadata.getEntityBindings()) {
            boolean compressed;
            String tableName = this.getTableName(entity);
            String statement = this.getAlterRowFormatString(tableName, compressed = compressionAllowed && entity.getMetaAttribute("xwiki-compressed") != null, rowFormats, session);
            if (statement == null) continue;
            NativeQuery query = session.createNativeQuery(statement);
            this.logger.info("Changing the table row type (currently [{}]) with [{}]", (Object)rowFormats.get(tableName), (Object)statement);
            session.getTransaction().begin();
            query.executeUpdate();
            session.getTransaction().commit();
        }
    }

    public String getAlterRowFormatString(String tableName, boolean compressed, Map<String, String> rowFormats, Session session) throws HibernateStoreException {
        String expectedRowFormat;
        String rowFormat = rowFormats.get(tableName);
        this.logger.debug("Row format for table [{}]: {}", (Object)tableName, (Object)rowFormat);
        String string = expectedRowFormat = compressed ? this.getCompressedRowFormat() : this.getDefaultRowFormat();
        if (!StringUtils.equalsIgnoreCase((CharSequence)rowFormat, (CharSequence)expectedRowFormat)) {
            return "ALTER TABLE " + tableName + " ROW_FORMAT=" + expectedRowFormat;
        }
        return null;
    }

    public Map<String, String> getRowFormats(Session session) {
        String currentDatabase = this.getDatabaseFromWikiName();
        NativeQuery query = session.createNativeQuery("SELECT DISTINCT NAME, ROW_FORMAT FROM " + this.getInformationShemaInnoDBTables() + " WHERE LOWER(NAME) LIKE '" + currentDatabase.toLowerCase() + "/%'");
        List results = query.list();
        HashMap<String, String> rowFormats = new HashMap<String, String>(results.size());
        for (Object[] entry : results) {
            String completeName = (String)entry[0];
            String tableName = completeName.substring(completeName.indexOf(47) + 1);
            rowFormats.put(tableName, (String)entry[1]);
        }
        return rowFormats;
    }

    public String getInformationShemaInnoDBTables() {
        return "INFORMATION_SCHEMA.INNODB_SYS_TABLES";
    }

    public String getDefaultRowFormat() {
        return "Dynamic";
    }

    public String getCompressedRowFormat() {
        return "Compressed";
    }

    @Override
    public boolean isCompressionAllowed() {
        return this.getCompressionAllowedConfiguration().orElse(true);
    }
}

