/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.hibernate.internal;

import com.xpn.xwiki.store.DatabaseProduct;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Optional;
import javax.annotation.Priority;
import org.xwiki.component.annotation.Component;
import org.xwiki.store.hibernate.DatabaseProductNameResolver;

@Component
@Singleton
@Priority(value=2000)
@Named(value="legacy")
public class LegacyDatabaseProductNameResolver
implements DatabaseProductNameResolver {
    @Override
    public Optional<String> resolve(String databaseProductName) {
        DatabaseProduct product = DatabaseProduct.toProduct(databaseProductName);
        if (product != DatabaseProduct.UNKNOWN) {
            return Optional.of(product.getJDBCScheme());
        }
        return Optional.empty();
    }
}

