/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authservice.script;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.user.api.XWikiAuthService;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.DocumentAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.authservice.XWikiAuthServiceComponent;
import org.xwiki.security.authservice.internal.AuthServiceConfiguration;
import org.xwiki.security.authservice.internal.AuthServiceManager;

@Component
@Named(value="security.authService")
@Singleton
public class AuthServiceScriptService
implements ScriptService {
    public static final String ID = "authService";
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    @Named(value="xwikicfg")
    private ConfigurationSource xwikicfg;
    @Inject
    private AuthServiceConfiguration configuration;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private DocumentAuthorizationManager authorization;
    @Inject
    private AuthServiceManager authServices;

    private void checkWikiAdmin() throws AccessDeniedException {
        XWikiContext xcontext = (XWikiContext)this.contextProvider.get();
        XWikiDocument sdoc = xcontext.getSecureDocument();
        DocumentReference contextDocumentReference = sdoc != null ? sdoc.getDocumentReference() : null;
        this.authorization.checkAccess(Right.ADMIN, EntityType.WIKI, xcontext.getAuthorReference(), contextDocumentReference);
    }

    public XWikiAuthService getAuthService() throws AccessDeniedException {
        this.checkWikiAdmin();
        XWikiContext xcontext = (XWikiContext)this.contextProvider.get();
        return xcontext.getWiki().getAuthService();
    }

    public String getConfiguredAuthClass() throws AccessDeniedException {
        this.checkWikiAdmin();
        return (String)this.xwikicfg.getProperty("xwiki.authentication.authclass");
    }

    public boolean isAuthServiceComponent() {
        XWikiContext xcontext = (XWikiContext)this.contextProvider.get();
        return xcontext.getWiki().isAuthServiceComponent();
    }

    public List<XWikiAuthServiceComponent> getAuthServices() throws AccessDeniedException, ComponentLookupException {
        this.checkWikiAdmin();
        return this.authServices.getAuthServices();
    }

    public void setAuthService(String id) throws AccessDeniedException, XWikiException {
        this.checkWikiAdmin();
        this.configuration.setAuthServiceId(id);
    }
}

