/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authservice.internal;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.user.api.XWikiAuthService;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.security.authservice.XWikiAuthServiceComponent;
import org.xwiki.security.authservice.internal.AuthServiceConfiguration;

@Component(roles={AuthServiceManager.class})
@Singleton
public class AuthServiceManager {
    @Inject
    private AuthServiceConfiguration configuration;
    @Inject
    @Named(value="standard")
    private XWikiAuthServiceComponent standardAuthenticator;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private Logger logger;

    public XWikiAuthService getAuthService() throws ComponentLookupException, XWikiException {
        String authHint = this.configuration.getAuthService();
        if (authHint != null) {
            ComponentManager componentManager = (ComponentManager)this.componentManagerProvider.get();
            if (componentManager.hasComponent(XWikiAuthServiceComponent.class, authHint)) {
                return (XWikiAuthService)componentManager.getInstance(XWikiAuthServiceComponent.class, authHint);
            }
            this.logger.warn("No authentication service could be found for identifier [{}]. Fallbacking on the standard one.", (Object)authHint);
        }
        return this.standardAuthenticator;
    }

    public List<XWikiAuthServiceComponent> getAuthServices() throws ComponentLookupException {
        return ((ComponentManager)this.componentManagerProvider.get()).getInstanceList(XWikiAuthServiceComponent.class);
    }
}

