/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authservice.internal;

import com.xpn.xwiki.internal.event.EntityEvent;
import com.xpn.xwiki.internal.event.XObjectPropertyAddedEvent;
import com.xpn.xwiki.internal.event.XObjectPropertyDeletedEvent;
import com.xpn.xwiki.internal.event.XObjectPropertyUpdatedEvent;
import com.xpn.xwiki.objects.BaseObjectReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.event.WikiDeletedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.security.authservice.internal.AuthServiceConfiguration;

@Component
@Named(value="AuthenticationServiceConfigurationInvalidator")
@Singleton
public class AuthServiceConfigurationInvalidator
extends AbstractEventListener {
    public static final String NAME = "AuthenticationServiceConfigurationInvalidator";
    private static final EntityReference PROPERTY_REFERENCE_MATCHER = new EntityReference("authService", EntityType.OBJECT_PROPERTY, (EntityReference)BaseObjectReference.any("XWiki.AuthService.ConfigurationClass"));
    @Inject
    private AuthServiceConfiguration configuration;

    public AuthServiceConfigurationInvalidator() {
        super(NAME, new Event[]{new WikiDeletedEvent(), new XObjectPropertyAddedEvent(PROPERTY_REFERENCE_MATCHER), new XObjectPropertyUpdatedEvent(PROPERTY_REFERENCE_MATCHER), new XObjectPropertyDeletedEvent(PROPERTY_REFERENCE_MATCHER)});
    }

    public void onEvent(Event event, Object source, Object data) {
        if (event instanceof WikiDeletedEvent) {
            this.configuration.invalidate(((WikiDeletedEvent)event).getWikiId());
        } else {
            this.configuration.invalidate(((EntityEvent)event).getReference().extractReference(EntityType.WIKI).getName());
        }
    }
}

