/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authservice.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.security.authservice.internal.AuthServiceConfigurationClassInitializer;

@Component(roles={AuthServiceConfiguration.class})
@Singleton
public class AuthServiceConfiguration {
    public static final List<String> SPACES = Arrays.asList("XWiki", "AuthService");
    public static final String SPACES_STRING = "XWiki.AuthService";
    public static final LocalDocumentReference DOC_REFERENCE = new LocalDocumentReference(SPACES, "Configuration");
    public static final String CONFIGURATION_INSTANCE_PROPERTY = "security.authentication.authService";
    private Map<String, ServiceCacheEntry> serviceCache = new ConcurrentHashMap<String, ServiceCacheEntry>();
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    @Named(value="xwikiproperties")
    private ConfigurationSource configurationSource;

    public String getAuthService() throws XWikiException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        String service = this.getAuthService(xcontext.getWikiReference(), xcontext);
        if (service != null) {
            return service;
        }
        if (!xcontext.isMainWiki() && (service = this.getAuthService(xcontext.getWikiReference(), xcontext)) != null) {
            return service;
        }
        return (String)this.configurationSource.getProperty(CONFIGURATION_INSTANCE_PROPERTY);
    }

    private String getAuthService(WikiReference wiki, XWikiContext xcontext) throws XWikiException {
        ServiceCacheEntry service = this.serviceCache.get(wiki.getName());
        if (service == null) {
            service = new ServiceCacheEntry(this.loadAuthServiceId(wiki, xcontext));
            this.serviceCache.put(wiki.getName(), service);
        }
        return service.name;
    }

    private String loadAuthServiceId(WikiReference wiki, XWikiContext xcontext) throws XWikiException {
        String serviceId;
        XWikiDocument configurationDocument = xcontext.getWiki().getDocument(new DocumentReference(DOC_REFERENCE, wiki), xcontext);
        BaseObject configurationObject = configurationDocument.getXObject((EntityReference)AuthServiceConfigurationClassInitializer.CLASS_REFERENCE);
        if (configurationObject != null && StringUtils.isNotBlank((CharSequence)(serviceId = configurationObject.getStringValue("authService")))) {
            return serviceId;
        }
        return null;
    }

    private void setAuthServiceId(String id, WikiReference wiki, XWikiContext xcontext) throws XWikiException {
        XWikiDocument configurationDocument = xcontext.getWiki().getDocument(new DocumentReference(DOC_REFERENCE, wiki), xcontext);
        configurationDocument = configurationDocument.clone();
        BaseObject configurationObject = configurationDocument.getXObject((EntityReference)AuthServiceConfigurationClassInitializer.CLASS_REFERENCE, true, xcontext);
        configurationObject.setStringValue("authService", StringUtils.defaultString((String)id));
        xcontext.getWiki().saveDocument(configurationDocument, "Change authenticator service", xcontext);
    }

    public void setAuthServiceId(String id) throws XWikiException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        this.setAuthServiceId(id, new WikiReference(xcontext.getWikiId()), xcontext);
    }

    public void invalidate(String wikiId) {
        this.serviceCache.remove(wikiId);
    }

    private class ServiceCacheEntry {
        private final String name;

        ServiceCacheEntry(String name) {
            this.name = name;
        }
    }
}

