/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.hql.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.parser.Node;
import net.sf.jsqlparser.parser.SimpleNode;
import net.sf.jsqlparser.parser.feature.Feature;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.Statements;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.util.validation.Validation;
import net.sf.jsqlparser.util.validation.feature.FeaturesAllowed;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.hql.internal.HQLCompleteStatementValidator;

@Component
@Singleton
@Named(value="standard")
public class StandardHQLCompleteStatementValidator
implements HQLCompleteStatementValidator {
    private static final String ID = "id";
    private static final String FIELD_ID = "id";
    private static final String DOCUMENT_FIELD_FULLNAME = "fullName";
    private static final String DOCUMENT_FIELD_NAME = "name";
    private static final String DOCUMENT_FIELD_SPACE = "space";
    private static final String DOCUMENT_FIELD_LANGUAGE = "language";
    private static final String DOCUMENT_FIELD_DEFAULTLANGUAGE = "defaultLanguage";
    private static final String DOCUMENT_FIELD_TRANSLATION = "translation";
    private static final String DOCUMENT_FIELD_HIDDEN = "hidden";
    private static final String SPACE_FIELD_REFERENCE = "reference";
    private static final String SPACE_FIELD_NAME = "name";
    private static final String SPACE_FIELD_PARENT = "parent";
    private static final String SPACE_FIELD_HIDDEN = "hidden";
    private static final String ATTACHMENT_FIELD_FILENAME = "filename";
    private static final String DELETEDATTACHMENT_FIELD_ID = "id";
    private static final String DELETEDATTACHMENT_FIELD_FILENAME = "filename";
    private static final String DELETEDOCUMENT_FIELD_ID = "id";
    private static final String DELETEDOCUMENT_FIELD_FULLNAME = "fullName";
    private static final String DELETEDOCUMENT_FIELD_LANGUAGE = "language";
    private static final String FUNCTION_COUNT = "count";
    private static final Set<String> ALLOWED_FUNCTIONS = Set.of("type", "treat", "cast", "str", "coalesce", "ifnull", "nullif", "extract", "format", "trunc", "truncate", "upper", "lower", "length", "concat", "locate", "position", "substring", "trim", "overlay", "pad", "left", "right", "replace", "repeat", "collate", "abs", "sign", "mod", "sqrt", "exp", "power", "ln", "round", "floor", "ceiling", "log10", "log", "pi", "sin", "cos", "tan", "asin", "acos", "atan", "atan2", "sinh", "cosh", "tanh", "degrees", "radians", "least", "greatest", "size", "element", "index", "key", "value", "entry", "elements", "indices", "id", "version", "naturalid", "fk", "array", "array_list", "array_agg", "array_position", "array_positions", "array_positions_list", "array_length", "array_concat", "array_prepend", "array_append", "array_contains", "array_contains_nullable", "array_includes", "array_includes_nullable", "array_intersects", "array_intersects_nullable", "array_get", "array_set", "array_remove", "array_remove_index", "array_slice", "array_replace", "array_trim", "array_fill", "array_fill_list", "array_to_string", "unnest", "json_object", "json_array", "json_value", "json_exists", "json_query", "json_arrayagg", "json_objectagg", "json_set", "json_remove()", "json_mergepatch", "json_array_append", "json_array_insert", "json_table", "xmlelement", "xmlcomment", "xmlforest", "xmlconcat", "xmlpi", "xmlquery", "xmlexists", "xmlagg", "xmltable", "in", "contains", "intersects", "count", "avg", "min", "max", "sum", "var_pop", "var_samp", "stddev_pop", "stddev_samp", "any", "some", "every", "all", "filter");
    private static final Map<String, Set<String>> ALLOWED_FIELDS = new HashMap<String, Set<String>>();

    @Override
    public Optional<Boolean> isSafe(String statementString) {
        Statements statements;
        Statement statement;
        FeaturesAllowed allowedFeatures = new FeaturesAllowed("xwiki", new Feature[0]);
        allowedFeatures.add((Collection)FeaturesAllowed.SELECT.getFeatures());
        allowedFeatures.add((Collection)FeaturesAllowed.JDBC.getFeatures());
        allowedFeatures.add((Collection)FeaturesAllowed.EXPRESSIONS.getFeatures());
        Validation validation = new Validation(List.of(allowedFeatures), new String[]{statementString});
        List errors = validation.validate();
        if (errors.isEmpty() && (statement = (Statement)(statements = validation.getParsedStatements()).getStatements().get(0)) instanceof Select && this.isSelectSafe((Select)statement)) {
            return Optional.of(true);
        }
        return Optional.of(false);
    }

    private boolean isSelectSafe(Select select2) {
        SelectBody selectBody = select2.getSelectBody();
        if (selectBody instanceof PlainSelect) {
            return this.isNodeSafe((Node)((PlainSelect)selectBody).getASTNode());
        }
        return false;
    }

    private boolean isPlainSelectSafe(PlainSelect plainSelect) {
        Map<String, String> tables = this.getTables(plainSelect);
        for (SelectItem selectItem : plainSelect.getSelectItems()) {
            if (this.isSelectItemAllowed(selectItem, tables)) continue;
            return false;
        }
        return true;
    }

    private boolean isNodeSafe(Node node) {
        Object value;
        if (node instanceof SimpleNode && ((value = ((SimpleNode)node).jjtGetValue()) instanceof Function ? !this.isFunctionSafe((Function)value) : value instanceof PlainSelect && !this.isPlainSelectSafe((PlainSelect)value))) {
            return false;
        }
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (this.isNodeSafe(node.jjtGetChild(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isFunctionSafe(Function function) {
        return ALLOWED_FUNCTIONS.contains(function.getName().toLowerCase());
    }

    private Map<String, String> getTables(PlainSelect plainSelect) {
        HashMap<String, String> tables = new HashMap<String, String>();
        this.addFromItem(plainSelect.getFromItem(), tables);
        List joins = plainSelect.getJoins();
        if (joins != null) {
            for (Join join : joins) {
                this.addFromItem(join.getRightItem(), tables);
            }
        }
        return tables;
    }

    private void addFromItem(FromItem item, Map<String, String> tables) {
        if (item instanceof Table) {
            String tableName = ((Table)item).getName();
            tables.put(item.getAlias() != null ? item.getAlias().getName() : tableName, tableName);
        }
    }

    private boolean isSelectItemAllowed(SelectItem selectItem, Map<String, String> tables) {
        if (selectItem instanceof SelectExpressionItem) {
            return this.isSelectExpressionAllowed(((SelectExpressionItem)selectItem).getExpression(), tables);
        }
        return false;
    }

    private boolean isAllowedAllTableColumns(ExpressionList parameters, Map<String, String> tables) {
        Expression expression = (Expression)parameters.getExpressions().get(0);
        return expression instanceof AllTableColumns && this.isTableAllowed(this.getTableName(((AllTableColumns)expression).getTable(), tables));
    }

    private boolean isAllowedAllColumns(ExpressionList parameters, Map<String, String> tables) {
        return parameters.getExpressions().get(0) instanceof AllColumns && tables.size() == 1 && this.isTableAllowed(tables.values().iterator().next());
    }

    private boolean isAllowedCountFunction(Function function, ExpressionList parameters, Map<String, String> tables) {
        return parameters.getExpressions().size() == 1 && function.getName().equalsIgnoreCase(FUNCTION_COUNT) && (this.isAllowedAllColumns(parameters, tables) || this.isAllowedAllTableColumns(parameters, tables));
    }

    private boolean isSelectExpressionAllowed(Expression expression, Map<String, String> tables) {
        boolean safe = false;
        if (expression instanceof Column) {
            if (this.isColumnAllowed((Column)expression, tables)) {
                safe = true;
            }
        } else if (expression instanceof Function) {
            safe = this.isSelectFunctionSafe((Function)expression, tables);
        }
        return safe;
    }

    private boolean isSelectFunctionSafe(Function function, Map<String, String> tables) {
        ExpressionList parameters = function.getParameters();
        if (this.isAllowedCountFunction(function, parameters, tables)) {
            return true;
        }
        for (Expression parameter : parameters.getExpressions()) {
            if (this.isSelectExpressionAllowed(parameter, tables)) continue;
            return false;
        }
        return true;
    }

    private boolean isColumnAllowed(Column column, Map<String, String> tables) {
        Set<String> fields = ALLOWED_FIELDS.get(this.getTableName(column.getTable(), tables));
        return fields != null && fields.contains(column.getColumnName());
    }

    private boolean isTableAllowed(String tableName) {
        return ALLOWED_FIELDS.containsKey(tableName);
    }

    private String getTableName(Table table, Map<String, String> tables) {
        String tableName = tables.values().iterator().next();
        if (table != null && StringUtils.isNotEmpty((CharSequence)table.getFullyQualifiedName())) {
            tableName = tables.get(table.getFullyQualifiedName());
        }
        return tableName;
    }

    static {
        HashSet<String> allowedDocFields = new HashSet<String>();
        ALLOWED_FIELDS.put("XWikiDocument", allowedDocFields);
        allowedDocFields.add("fullName");
        allowedDocFields.add("name");
        allowedDocFields.add(DOCUMENT_FIELD_SPACE);
        allowedDocFields.add("language");
        allowedDocFields.add(DOCUMENT_FIELD_DEFAULTLANGUAGE);
        allowedDocFields.add(DOCUMENT_FIELD_TRANSLATION);
        allowedDocFields.add("hidden");
        HashSet<String> allowedDeletedDocumentFields = new HashSet<String>();
        ALLOWED_FIELDS.put("XWikiDeletedDocument", allowedDeletedDocumentFields);
        allowedDeletedDocumentFields.add("id");
        allowedDeletedDocumentFields.add("fullName");
        allowedDeletedDocumentFields.add("language");
        HashSet<String> allowedSpaceFields = new HashSet<String>();
        ALLOWED_FIELDS.put("XWikiSpace", allowedSpaceFields);
        allowedSpaceFields.add(SPACE_FIELD_REFERENCE);
        allowedSpaceFields.add("name");
        allowedSpaceFields.add(SPACE_FIELD_PARENT);
        allowedSpaceFields.add("hidden");
        ALLOWED_FIELDS.put("XWikiAttachment", Collections.singleton("filename"));
        HashSet<String> allowedDeletedAttachmentFields = new HashSet<String>();
        ALLOWED_FIELDS.put("DeletedAttachment", allowedDeletedAttachmentFields);
        allowedDeletedAttachmentFields.add("id");
        allowedDeletedAttachmentFields.add("filename");
    }
}

