/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.hql.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.query.hql.internal.HQLCompleteStatementValidator;

@Component
@Singleton
@Named(value="configurable")
@Priority(value=900)
public class ConfigurableHQLCompleteStatementValidator
implements HQLCompleteStatementValidator,
Initializable {
    @Inject
    @Named(value="xwikiproperties")
    private ConfigurationSource configuration;
    private List<Pattern> unsafe;
    private List<Pattern> safe;

    public void initialize() throws InitializationException {
        this.unsafe = this.getPatterns("query.hql.unsafe");
        this.safe = this.getPatterns("query.hql.safe");
    }

    private List<Pattern> getPatterns(String key) throws InitializationException {
        List<Pattern> patterns;
        List patternStrings = (List)this.configuration.getProperty(key, List.class);
        if (patternStrings != null) {
            patterns = new ArrayList<Pattern>(patternStrings.size());
            for (String patternString : patternStrings) {
                try {
                    patterns.add(Pattern.compile(patternString));
                }
                catch (Exception e) {
                    throw new InitializationException(String.format("Failed to parse pattern [%s] for configuration [%s]", patternString, key), (Throwable)e);
                }
            }
        } else {
            patterns = List.of();
        }
        return patterns;
    }

    @Override
    public Optional<Boolean> isSafe(String statement) {
        for (Pattern pattern : this.unsafe) {
            if (!pattern.matcher(statement).matches()) continue;
            return Optional.of(Boolean.FALSE);
        }
        for (Pattern pattern : this.safe) {
            if (!pattern.matcher(statement).matches()) continue;
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }
}

