/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.document;

import com.xpn.xwiki.doc.XWikiDocument;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.model.document.DocumentAuthors;
import org.xwiki.text.XWikiToStringBuilder;
import org.xwiki.user.GuestUserReference;
import org.xwiki.user.UserReference;

public class DefaultDocumentAuthors
implements DocumentAuthors {
    private final XWikiDocument documentHolder;
    private UserReference contentAuthor;
    private UserReference effectiveMetadataAuthor;
    private UserReference originalMetadataAuthor;
    private UserReference creator;

    public DefaultDocumentAuthors(XWikiDocument documentHolder) {
        this.documentHolder = documentHolder;
        this.contentAuthor = GuestUserReference.INSTANCE;
        this.effectiveMetadataAuthor = GuestUserReference.INSTANCE;
        this.originalMetadataAuthor = GuestUserReference.INSTANCE;
        this.creator = GuestUserReference.INSTANCE;
    }

    public void copyAuthors(DocumentAuthors documentAuthors) {
        this.setContentAuthor(documentAuthors.getContentAuthor());
        this.setEffectiveMetadataAuthor(documentAuthors.getEffectiveMetadataAuthor());
        this.setOriginalMetadataAuthor(documentAuthors.getOriginalMetadataAuthor());
        this.setCreator(documentAuthors.getCreator());
    }

    public void setContentAuthor(UserReference contentAuthor) {
        if (!Objects.equals(this.contentAuthor, contentAuthor)) {
            this.contentAuthor = contentAuthor;
            this.flagMetadataDirty();
        }
    }

    public void setEffectiveMetadataAuthor(UserReference metadataAuthor) {
        if (!Objects.equals(this.effectiveMetadataAuthor, metadataAuthor)) {
            this.effectiveMetadataAuthor = metadataAuthor;
            this.flagMetadataDirty();
        }
    }

    public void setOriginalMetadataAuthor(UserReference originalMetadataAuthor) {
        if (!Objects.equals(this.originalMetadataAuthor, originalMetadataAuthor)) {
            this.originalMetadataAuthor = originalMetadataAuthor;
            this.flagMetadataDirty();
        }
    }

    public void setCreator(UserReference creator) {
        if (!Objects.equals(this.creator, creator)) {
            this.creator = creator;
            this.flagMetadataDirty();
        }
    }

    private void flagMetadataDirty() {
        this.documentHolder.setMetaDataDirty(true);
    }

    public UserReference getContentAuthor() {
        return this.contentAuthor;
    }

    public UserReference getEffectiveMetadataAuthor() {
        return this.effectiveMetadataAuthor;
    }

    public UserReference getOriginalMetadataAuthor() {
        return this.originalMetadataAuthor;
    }

    public UserReference getCreator() {
        return this.creator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultDocumentAuthors that = (DefaultDocumentAuthors)o;
        return new EqualsBuilder().append((Object)this.contentAuthor, (Object)that.contentAuthor).append((Object)this.effectiveMetadataAuthor, (Object)that.effectiveMetadataAuthor).append((Object)this.originalMetadataAuthor, (Object)that.originalMetadataAuthor).append((Object)this.creator, (Object)that.creator).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 67).append((Object)this.contentAuthor).append((Object)this.effectiveMetadataAuthor).append((Object)this.originalMetadataAuthor).append((Object)this.creator).toHashCode();
    }

    public String toString() {
        return new XWikiToStringBuilder((Object)this).append("documentHolder", (Object)this.documentHolder).append("contentAuthor", (Object)this.contentAuthor).append("effectiveMetadataAuthor", (Object)this.effectiveMetadataAuthor).append("originalMetadataAuthor", (Object)this.originalMetadataAuthor).append("creator", (Object)this.creator).toString();
    }
}

