/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.legacy.internal.oldcore.notification;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.notify.XWikiNotificationManager;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.event.ActionExecutedEvent;
import org.xwiki.bridge.event.ActionExecutingEvent;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentCreatingEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentDeletingEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.bridge.event.DocumentUpdatingEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="LegacyNotificationDispatcher")
@Singleton
@Deprecated
public class LegacyNotificationDispatcher
implements EventListener {
    @Inject
    private Logger logger;

    public String getName() {
        return "LegacyNotificationDispatcher";
    }

    public List<Event> getEvents() {
        return new ArrayList<Event>(){
            {
                this.add(new DocumentDeletedEvent());
                this.add(new DocumentCreatedEvent());
                this.add(new DocumentUpdatedEvent());
                this.add(new DocumentDeletingEvent());
                this.add(new DocumentCreatingEvent());
                this.add(new DocumentUpdatingEvent());
                this.add(new ActionExecutedEvent());
                this.add(new ActionExecutingEvent());
            }
        };
    }

    private XWikiNotificationManager getNotificationManager(XWikiContext context) {
        try {
            return (XWikiNotificationManager)XWiki.class.getMethod("getNotificationManager", new Class[0]).invoke((Object)context.getWiki(), new Object[0]);
        }
        catch (Exception e) {
            this.logger.error("Failed to get [XWikiNotificationManager]", (Throwable)e);
            return null;
        }
    }

    public void onEvent(Event event, Object source, Object data) {
        XWikiDocument document = (XWikiDocument)source;
        XWikiDocument originalDocument = document.getOriginalDocument();
        XWikiContext context = (XWikiContext)data;
        XWikiNotificationManager manager = this.getNotificationManager((XWikiContext)data);
        if (manager != null) {
            if (event instanceof DocumentCreatedEvent) {
                manager.verify(document, originalDocument, 1, context);
            } else if (event instanceof DocumentUpdatedEvent) {
                manager.verify(document, originalDocument, 0, context);
            } else if (event instanceof DocumentCreatingEvent) {
                manager.preverify(document, originalDocument, 1, context);
            } else if (event instanceof DocumentUpdatingEvent) {
                manager.preverify(document, originalDocument, 0, context);
            } else if (event instanceof DocumentDeletedEvent) {
                manager.verify(new XWikiDocument(document.getDocumentReference()), document, 2, context);
            } else if (event instanceof DocumentDeletingEvent) {
                manager.preverify(document, new XWikiDocument(document.getDocumentReference()), 2, context);
            } else if (event instanceof ActionExecutedEvent) {
                manager.verify(document, ((ActionExecutedEvent)event).getActionName(), context);
            } else if (event instanceof ActionExecutingEvent) {
                manager.preverify(document, ((ActionExecutingEvent)event).getActionName(), context);
            }
        } else {
            this.logger.error("Can't find old [XWikiNotificationManager] system");
        }
    }
}

