/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.internal.web;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.DocumentRevisionProvider;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.web.XWikiRequest;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.internal.web.DocExistValidator;

@Component
@Singleton
@Named(value="view")
public class ViewDocExistValidator
implements DocExistValidator {
    private static final String VIEWER_REQUEST_PARAMETER = "viewer";
    private static final String REV_REQUEST_PARAMETER = "rev";
    private static final String VIEWER_RECYCLEBIN = "recyclebin";
    private static final String VIEWER_CHILDREN = "children";
    private static final String VIEWER_SIBLINGS = "siblings";
    @Inject
    private DocumentRevisionProvider documentRevisionProvider;
    @Inject
    private Logger logger;

    @Override
    public boolean docExist(XWikiDocument doc, XWikiContext context) {
        boolean hasRev;
        boolean result = false;
        XWikiRequest request = context.getRequest();
        String rev = request.get(REV_REQUEST_PARAMETER);
        boolean bl = hasRev = rev != null;
        if (doc.isNew() && !hasRev) {
            String viewer = request.get(VIEWER_REQUEST_PARAMETER);
            result = !VIEWER_RECYCLEBIN.equals(viewer) && !VIEWER_CHILDREN.equals(viewer) && !VIEWER_SIBLINGS.equals(viewer);
        } else if (hasRev) {
            return !this.revisionExists(doc, rev);
        }
        return result;
    }

    private boolean revisionExists(XWikiDocument doc, String rev) {
        boolean result;
        try {
            XWikiDocument revisionDoc = this.documentRevisionProvider.getRevision(doc, rev);
            result = revisionDoc != null;
        }
        catch (XWikiException e) {
            this.logger.warn("Error while accessing document [{}] in revision [{}]. Cause: [{}].", new Object[]{doc.getDocumentReference(), rev, ExceptionUtils.getRootCauseMessage((Throwable)e)});
            result = false;
        }
        return result;
    }
}

