/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.internal.velocity;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.api.DeprecatedContext;
import com.xpn.xwiki.internal.template.InternalTemplateManager;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.context.ExecutionContext;
import org.xwiki.environment.Environment;
import org.xwiki.model.EntityType;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.security.authorization.DocumentAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.skin.Skin;
import org.xwiki.skin.SkinManager;
import org.xwiki.template.Template;
import org.xwiki.template.event.TemplateDeletedEvent;
import org.xwiki.template.event.TemplateEvent;
import org.xwiki.template.event.TemplateUpdatedEvent;
import org.xwiki.velocity.ScriptVelocityContext;
import org.xwiki.velocity.VelocityEngine;
import org.xwiki.velocity.VelocityTemplate;
import org.xwiki.velocity.XWikiVelocityException;
import org.xwiki.velocity.internal.DefaultVelocityManager;

@Component
@Singleton
public class XWikiVelocityManager
extends DefaultVelocityManager
implements Initializable {
    private static final String VELOCITYENGINE_CACHEKEY_NAME = "velocity.engine.key";
    private static final List<Event> EVENTS = Arrays.asList(new TemplateUpdatedEvent(), new TemplateDeletedEvent());
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private Provider<InternalTemplateManager> templates;
    @Inject
    private SkinManager skinManager;
    @Inject
    private ObservationManager observation;
    @Inject
    private Environment environment;
    @Inject
    private DocumentAuthorizationManager authorizationManager;
    @Inject
    private Logger logger;
    private final Map<String, VelocityEngine> velocityEngines = new ConcurrentHashMap<String, VelocityEngine>();

    public void initialize() throws InitializationException {
        super.initialize();
        this.observation.addListener(new EventListener(){

            public void onEvent(Event event, Object source, Object data) {
                if (event instanceof TemplateEvent) {
                    TemplateEvent templateEvent = (TemplateEvent)event;
                    XWikiVelocityManager.this.velocityEngines.remove(templateEvent.getId());
                }
            }

            public String getName() {
                return XWikiVelocityManager.class.getName();
            }

            public List<Event> getEvents() {
                return EVENTS;
            }
        });
    }

    protected ScriptVelocityContext getScriptVelocityContext() {
        ScriptVelocityContext velocityContext = super.getScriptVelocityContext();
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        velocityContext.put("context", (Object)new DeprecatedContext(xcontext));
        return velocityContext;
    }

    private Template getSkinMacrosTemplate() {
        Template template = null;
        HashMap<String, Template> templateCache = null;
        Skin currentSkin = this.skinManager.getCurrentSkin(true);
        ExecutionContext econtext = this.execution.getContext();
        if (econtext != null) {
            templateCache = (HashMap<String, Template>)econtext.getProperty(VELOCITYENGINE_CACHEKEY_NAME);
            if (templateCache == null) {
                templateCache = new HashMap<String, Template>();
                econtext.setProperty(VELOCITYENGINE_CACHEKEY_NAME, templateCache);
            } else {
                template = (Template)templateCache.get(currentSkin.getId());
            }
        }
        if (template == null) {
            template = ((InternalTemplateManager)this.templates.get()).getSkinTemplate("macros.vm");
            if (templateCache != null) {
                templateCache.put(currentSkin.getId(), template);
            }
        }
        return template;
    }

    public VelocityEngine getVelocityEngine() throws XWikiVelocityException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        Template skinMacrosTemplate = xcontext != null && xcontext.getWiki() != null ? this.getSkinMacrosTemplate() : null;
        String cacheKey = skinMacrosTemplate != null ? skinMacrosTemplate.getId() : "default";
        VelocityEngine velocityEngine = this.velocityEngines.get(cacheKey);
        if (velocityEngine == null) {
            velocityEngine = this.createVelocityEngine(cacheKey, skinMacrosTemplate);
        }
        return velocityEngine;
    }

    private synchronized VelocityEngine createVelocityEngine(String cacheKey, Template skinMacrosTemplate) throws XWikiVelocityException {
        VelocityEngine velocityEngine = this.velocityEngines.get(cacheKey);
        if (velocityEngine == null) {
            velocityEngine = this.createVelocityEngine();
            try {
                this.injectBaseMacros(velocityEngine, skinMacrosTemplate);
            }
            catch (Exception e) {
                this.logger.warn("Failed to load global macros for engine with key [{}]: {}", (Object)cacheKey, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
            this.velocityEngines.put(cacheKey, velocityEngine);
        }
        return velocityEngine;
    }

    private void injectBaseMacros(VelocityEngine velocityEngine, Template skinMacrosTemplate) throws Exception {
        block12: {
            try (InputStream stream = this.environment.getResourceAsStream("/templates/macros.vm");){
                if (stream == null) break block12;
                try (InputStreamReader reader = new InputStreamReader(stream);){
                    VelocityTemplate mainMacros = this.compile("", reader);
                    velocityEngine.addGlobalMacros(mainMacros.getMacros());
                }
            }
        }
        if (skinMacrosTemplate != null && this.authorizationManager.hasAccess(Right.SCRIPT, EntityType.DOCUMENT, skinMacrosTemplate.getContent().getAuthorReference(), skinMacrosTemplate.getContent().getDocumentReference())) {
            VelocityTemplate skinMacros = this.compile("", new StringReader(skinMacrosTemplate.getContent().getContent()));
            velocityEngine.addGlobalMacros(skinMacros.getMacros());
        }
    }
}

