/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.internal.migration;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.internal.extension.XARExtensionIndex;
import org.xwiki.internal.migration.AbstractDocumentsMigration;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.query.QueryException;

@Component
@Named(value="R150000000XWIKI20285")
@Singleton
public class R150000000XWIKI20285DataMigration
extends AbstractDocumentsMigration {
    @Inject
    private XARExtensionIndex installedXARs;

    @Override
    public String getDescription() {
        return "Patch the InvitationConfig documents with improper escaping.";
    }

    @Override
    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(150700000);
    }

    @Override
    protected String getTaskType() {
        return "internal-document-parameter-escaping";
    }

    @Override
    protected List<DocumentReference> selectDocuments() throws DataMigrationException {
        XWiki wiki = this.getXWikiContext().getWiki();
        try {
            return wiki.getStore().getQueryManager().createQuery("select doc.fullName, doc.language from Document doc where doc.content like '%{{info}}%services.localization.render%xe.invitation.internalDocument%{{/info}}%'", "xwql").execute().stream().flatMap(array -> {
                String locale = Objects.toString(array[1], "");
                return this.resolveDocumentReference(String.valueOf(array[0]), locale).stream();
            }).filter(documentReference -> !this.installedXARs.isExtensionDocument((DocumentReference)documentReference)).collect(Collectors.toList());
        }
        catch (QueryException e) {
            throw new DataMigrationException(String.format("Failed retrieve the list of all the documents for wiki [%s].", wiki.getName()), e);
        }
    }
}

