/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.internal.migration;

import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.syntax.Syntax;

@Component(roles={InvitationInternalDocumentParameterEscapingFixer.class})
@Singleton
public class InvitationInternalDocumentParameterEscapingFixer {
    private static final Pattern PATTERN = Pattern.compile("(\\{\\{info}}\\$services\\.localization\\.render\\('xe\\.invitation\\.internalDocument', \\[)(\"[^\"]+\")(]\\)\\{\\{/info}})");

    public Optional<String> fix(String content, Syntax syntax) {
        String escapedContent = PATTERN.matcher(content).replaceAll(matchResult -> {
            if (matchResult.group(2).contains("services.rendering.escape")) {
                return matchResult.group();
            }
            String format = String.format("%s$services.rendering.escape(%s, '%s')%s", matchResult.group(1), matchResult.group(2), syntax.toIdString(), matchResult.group(3));
            return Matcher.quoteReplacement(format);
        });
        if (Objects.equals(escapedContent, content)) {
            return Optional.empty();
        }
        return Optional.of(escapedContent);
    }
}

