/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.internal.migration;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.index.TaskManager;
import org.xwiki.localization.LocaleUtils;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;

public abstract class AbstractDocumentsMigration
extends AbstractHibernateDataMigration {
    @Inject
    protected Logger logger;
    @Inject
    @Named(value="current")
    protected DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private TaskManager taskManager;

    @Override
    protected void hibernateMigrate() throws DataMigrationException {
        List<DocumentReference> selectedDocuments = this.selectDocuments();
        this.logBeforeQueuingTasks(selectedDocuments);
        for (DocumentReference documentReference : selectedDocuments) {
            this.logBeforeQueuingTask(documentReference);
            this.taskManager.addTask(this.getXWikiContext().getWikiId(), new XWikiDocument(documentReference).getId(), this.getTaskType());
        }
    }

    protected abstract String getTaskType();

    protected abstract List<DocumentReference> selectDocuments() throws DataMigrationException;

    protected void logBeforeQueuingTasks(List<DocumentReference> documents) {
        this.logger.info("[{}] documents queued to task [{}]", (Object)documents.size(), (Object)this.getTaskType());
    }

    protected void logBeforeQueuingTask(DocumentReference documentReference) {
        this.logger.info("document [{}] queued to task [{}]", (Object)documentReference, (Object)this.getTaskType());
    }

    protected Optional<DocumentReference> resolveDocumentReference(String documentReference, String localeStr) {
        Optional<DocumentReference> optionalDocumentReference = this.parseLocale(localeStr).map(locale -> new DocumentReference((EntityReference)this.documentReferenceResolver.resolve((Object)documentReference, new Object[0]), locale));
        if (optionalDocumentReference.isEmpty()) {
            this.logger.warn("Failed to resolve document reference [{}] with locale [{}]", (Object)documentReference, (Object)localeStr);
        }
        return optionalDocumentReference;
    }

    private Optional<Locale> parseLocale(String locale) {
        try {
            return Optional.ofNullable(LocaleUtils.toLocale((String)locale));
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("Unable to resolve locale [{}]. Cause: [{}]", (Object)locale, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return Optional.empty();
        }
    }
}

