/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.internal.filter;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.internal.event.XARImportedEvent;
import com.xpn.xwiki.internal.event.XARImportingEvent;
import com.xpn.xwiki.plugin.packaging.Package;
import com.xpn.xwiki.web.Utils;
import java.io.IOException;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.xwiki.component.annotation.Component;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.event.model.WikiDocumentFilter;
import org.xwiki.filter.input.BeanInputFilterStream;
import org.xwiki.filter.input.BeanInputFilterStreamFactory;
import org.xwiki.filter.input.InputFilterStreamFactory;
import org.xwiki.filter.input.InputSource;
import org.xwiki.filter.instance.output.DocumentInstanceOutputProperties;
import org.xwiki.filter.instance.output.InstanceOutputProperties;
import org.xwiki.filter.output.BeanOutputFilterStream;
import org.xwiki.filter.output.BeanOutputFilterStreamFactory;
import org.xwiki.filter.output.OutputFilterStreamFactory;
import org.xwiki.filter.xar.input.XARInputProperties;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.LogQueue;
import org.xwiki.logging.LoggerManager;
import org.xwiki.logging.event.LogEvent;
import org.xwiki.logging.event.LoggerListener;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.EntityReferenceSet;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

@Component(roles={Importer.class})
@Singleton
public class Importer {
    @Inject
    @Named(value="xwiki+xar/1.6")
    private InputFilterStreamFactory xarFilterStreamFactory;
    @Inject
    @Named(value="xwiki+instance")
    private OutputFilterStreamFactory instanceFilterStreamFactory;
    @Inject
    private ObservationManager observation;
    @Inject
    private Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importXAR(InputSource source, EntityReferenceSet entities, String historyStrategy, boolean backup, XWikiContext context) throws IOException, FilterException {
        XARInputProperties xarProperties = new XARInputProperties();
        xarProperties.setSource(source);
        DocumentInstanceOutputProperties instanceProperties = new DocumentInstanceOutputProperties();
        instanceProperties.setSaveComment("Imported from XAR");
        if (entities != null) {
            xarProperties.setEntities(entities);
        }
        this.setHistoryStrategy(historyStrategy, xarProperties, instanceProperties);
        instanceProperties.setAuthorPreserved(backup);
        xarProperties.setVerbose(true);
        instanceProperties.setVerbose(true);
        instanceProperties.setStoppedWhenSaveFail(false);
        try (LogQueue importLogger = new LogQueue();){
            LoggerManager loggerManager = Utils.getComponent(LoggerManager.class);
            if (loggerManager != null) {
                loggerManager.pushLogListener((EventListener)new LoggerListener(UUID.randomUUID().toString(), (org.xwiki.logging.Logger)importLogger));
            }
            BeanInputFilterStream<XARInputProperties> xarFilterStream = this.createXARFilterStream(xarProperties);
            BeanOutputFilterStream<InstanceOutputProperties> instanceFilterStream = this.createInstanceFilterStream(instanceProperties);
            this.observation.notify((Event)new XARImportingEvent(), null, (Object)context);
            try {
                xarFilterStream.read(instanceFilterStream.getFilter());
                xarFilterStream.close();
                instanceFilterStream.close();
            }
            finally {
                if (loggerManager != null) {
                    loggerManager.popLogListener();
                }
                if (this.logger.isDebugEnabled()) {
                    importLogger.log(this.logger);
                } else {
                    for (LogEvent logEvent : importLogger.getLogsFrom(LogLevel.ERROR)) {
                        logEvent.log(this.logger);
                    }
                }
                source.close();
                this.observation.notify((Event)new XARImportedEvent(), null, (Object)context);
            }
            this.generateReport(importLogger, context);
        }
        catch (Exception e) {
            this.logger.warn("Failed to close the log queue: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    private BeanInputFilterStream<XARInputProperties> createXARFilterStream(XARInputProperties xarProperties) throws FilterException {
        BeanInputFilterStreamFactory xarInputfactory = (BeanInputFilterStreamFactory)this.xarFilterStreamFactory;
        return xarInputfactory.createInputFilterStream((Object)xarProperties);
    }

    private BeanOutputFilterStream<InstanceOutputProperties> createInstanceFilterStream(DocumentInstanceOutputProperties instanceProperties) throws FilterException {
        BeanOutputFilterStreamFactory instanceOutputFactory = (BeanOutputFilterStreamFactory)this.instanceFilterStreamFactory;
        return instanceOutputFactory.createOutputFilterStream((Object)instanceProperties);
    }

    private void setHistoryStrategy(String historyStrategy, XARInputProperties xarProperties, DocumentInstanceOutputProperties instanceProperties) {
        if (StringUtils.equalsIgnoreCase((CharSequence)historyStrategy, (CharSequence)"reset")) {
            instanceProperties.setPreviousDeleted(true);
            instanceProperties.setVersionPreserved(false);
            xarProperties.setWithHistory(false);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)historyStrategy, (CharSequence)"replace")) {
            instanceProperties.setPreviousDeleted(true);
            instanceProperties.setVersionPreserved(true);
            xarProperties.setWithHistory(true);
        } else {
            instanceProperties.setPreviousDeleted(false);
            instanceProperties.setVersionPreserved(false);
            xarProperties.setWithHistory(false);
        }
    }

    private void generateReport(LogQueue importLogger, XWikiContext context) {
        Package oldImporter = new Package();
        context.put("install_status", (Object)(importLogger.containLogsFrom(LogLevel.ERROR) ? 4 : 2));
        EntityReferenceSerializer serializer = (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING, "local");
        for (LogEvent log : importLogger) {
            Object entity;
            Marker marker = log.getMarker();
            if (marker == null) continue;
            if (marker.contains(WikiDocumentFilter.LOG_DOCUMENT_CREATED.getName()) || marker.contains(WikiDocumentFilter.LOG_DOCUMENT_UPDATED.getName())) {
                oldImporter.getInstalled(context).add((String)serializer.serialize((EntityReference)log.getArgumentArray()[0], new Object[0]));
                continue;
            }
            if (marker.contains(WikiDocumentFilter.LOG_DOCUMENT_SKIPPED.getName())) {
                oldImporter.getSkipped(context).add((String)serializer.serialize((EntityReference)log.getArgumentArray()[0], new Object[0]));
                continue;
            }
            if (!marker.contains(WikiDocumentFilter.LOG_DOCUMENT_ERROR.getName()) || (entity = log.getArgumentArray()[0]) == null) continue;
            oldImporter.getErrors(context).add(entity instanceof EntityReference ? (String)serializer.serialize((EntityReference)log.getArgumentArray()[0], new Object[0]) : entity.toString());
        }
    }
}

