/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.internal.document;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.authorization.requiredrights.DocumentRequiredRight;
import org.xwiki.security.authorization.requiredrights.DocumentRequiredRights;

@Component(roles={DocumentRequiredRightsReader.class})
@Singleton
public class DocumentRequiredRightsReader {
    public static final LocalDocumentReference CLASS_REFERENCE = new LocalDocumentReference("XWiki", "RequiredRightClass");
    public static final String PROPERTY_NAME = "level";
    private static final DocumentRequiredRights ENFORCED_EMPTY = new DocumentRequiredRights(true, Set.of());
    private static final DocumentRequiredRights ENFORCED_SCRIPT = new DocumentRequiredRights(true, Set.of(new DocumentRequiredRight(Right.SCRIPT, EntityType.DOCUMENT)));
    private static final DocumentRequiredRights ENFORCED_PROGRAMMING = new DocumentRequiredRights(true, Set.of(new DocumentRequiredRight(Right.PROGRAM, null)));
    private static final DocumentRequiredRights ENFORCED_ADMIN = new DocumentRequiredRights(true, Set.of(new DocumentRequiredRight(Right.ADMIN, EntityType.WIKI)));
    private static final List<DocumentRequiredRights> STATIC_INSTANCES = List.of(ENFORCED_EMPTY, ENFORCED_SCRIPT, ENFORCED_PROGRAMMING, ENFORCED_ADMIN);
    @Inject
    private Logger logger;

    public DocumentRequiredRights readRequiredRights(XWikiDocument document) {
        boolean enforce = document.isEnforceRequiredRights();
        Set rights = document.getXObjects((EntityReference)CLASS_REFERENCE).stream().filter(Objects::nonNull).map(this::readRequiredRight).filter(requiredRight -> !Right.EDIT.equals(requiredRight.right()) && !Right.ILLEGAL.equals(requiredRight.right())).collect(Collectors.toUnmodifiableSet());
        if (!enforce && rights.isEmpty()) {
            return DocumentRequiredRights.EMPTY;
        }
        if (enforce) {
            for (DocumentRequiredRights staticInstance : STATIC_INSTANCES) {
                if (!staticInstance.rights().equals(rights)) continue;
                return staticInstance;
            }
        }
        return new DocumentRequiredRights(enforce, rights);
    }

    public DocumentRequiredRight readRequiredRight(BaseObject object) {
        String[] levelRight;
        String value = object.getStringValue(PROPERTY_NAME);
        EntityType initialEntityType = EntityType.DOCUMENT;
        Right right = Right.toRight((String)value);
        if (right.equals(Right.ILLEGAL) && (levelRight = StringUtils.split((String)value, (String)"_", (int)2)).length == 2) {
            right = Right.toRight((String)levelRight[1]);
            try {
                initialEntityType = EntityType.valueOf((String)levelRight[0].toUpperCase());
            }
            catch (IllegalArgumentException e) {
                right = Right.ILLEGAL;
                this.logger.warn("Illegal required right value [{}] in object [{}]", (Object)value, object.getReference());
            }
        }
        EntityType entityType = this.getEffectiveEntityType(right, initialEntityType, object.getDocumentReference());
        return new DocumentRequiredRight(right, entityType);
    }

    public EntityType getEffectiveEntityType(Right right, EntityType initialEntityType, DocumentReference baseDocumentReference) {
        EntityType entityType = initialEntityType;
        Set targetedEntityTypes = right.getTargetedEntityType();
        if (targetedEntityTypes == null) {
            entityType = null;
        } else {
            EntityReference entityReference = baseDocumentReference.extractReference(entityType);
            if (entityReference == null) {
                entityReference = baseDocumentReference;
            }
            while (!targetedEntityTypes.contains(entityType) && entityReference != null) {
                entityType = entityReference.getType();
                entityReference = entityReference.getParent();
            }
            if (!targetedEntityTypes.contains(entityType)) {
                entityType = EntityType.DOCUMENT;
            }
        }
        return entityType;
    }
}

