/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.internal.attachment;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import java.io.IOException;
import java.io.InputStream;
import org.xwiki.attachment.AttachmentAccessWrapper;

public class XWikiAttachmentAccessWrapper
implements AttachmentAccessWrapper {
    private final XWikiAttachment attachment;
    private final XWikiContext context;

    public XWikiAttachmentAccessWrapper(XWikiAttachment attachment, XWikiContext context) {
        this.attachment = attachment;
        this.context = context;
    }

    public long getSize() {
        return this.attachment.getLongSize();
    }

    public InputStream getInputStream() throws IOException {
        try {
            return this.attachment.getContentInputStream(this.context);
        }
        catch (XWikiException e) {
            throw new IOException(String.format("Failed to read the input stream for attachment [%s]", this.attachment), e);
        }
    }

    public String getFileName() {
        return this.attachment.getFilename();
    }
}

