/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.evaluation.internal;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.xwiki.component.annotation.Component;
import org.xwiki.evaluation.ObjectEvaluatorException;
import org.xwiki.evaluation.ObjectPropertyEvaluator;
import org.xwiki.model.EntityType;
import org.xwiki.model.document.DocumentAuthors;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.security.authorization.AuthorExecutor;
import org.xwiki.security.authorization.DocumentAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.user.UserReferenceSerializer;
import org.xwiki.velocity.VelocityManager;

@Component
@Singleton
@Named(value="velocity")
public class VelocityObjectPropertyEvaluator
implements ObjectPropertyEvaluator {
    @Inject
    private DocumentAuthorizationManager authorizationManager;
    @Inject
    private AuthorExecutor authorExecutor;
    @Inject
    private VelocityManager velocityManager;
    @Inject
    @Named(value="document")
    private UserReferenceSerializer<DocumentReference> documentUserSerializer;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;

    @Override
    public Map<String, String> evaluateProperties(BaseObject object, String ... properties) throws ObjectEvaluatorException {
        HashMap<String, String> evaluatedProperties = new HashMap<String, String>();
        for (String property : properties) {
            evaluatedProperties.put(property, object.getStringValue(property));
        }
        DocumentReference documentReference = object.getDocumentReference();
        XWikiDocument ownerDocument = object.getOwnerDocument();
        DocumentAuthors documentAuthors = ownerDocument.getAuthors();
        DocumentReference authorReference = (DocumentReference)this.documentUserSerializer.serialize(documentAuthors.getEffectiveMetadataAuthor());
        if (!ownerDocument.isRestricted() && this.authorizationManager.hasAccess(Right.SCRIPT, EntityType.DOCUMENT, authorReference, documentReference)) {
            try {
                this.authorExecutor.call(() -> {
                    VelocityContext context = this.velocityManager.getVelocityContext();
                    for (Map.Entry entry : evaluatedProperties.entrySet()) {
                        StringWriter writer = new StringWriter();
                        String serializedPropertyReference = (String)this.entityReferenceSerializer.serialize(object.getField((String)entry.getKey()).getReference(), new Object[0]);
                        this.velocityManager.getVelocityEngine().evaluate((Context)context, (Writer)writer, serializedPropertyReference, (String)entry.getValue());
                        entry.setValue(writer.toString());
                    }
                    return null;
                }, authorReference, documentReference);
            }
            catch (Exception e) {
                throw new ObjectEvaluatorException("Failed to run Velocity engine.", e);
            }
        }
        return evaluatedProperties;
    }
}

