/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.evaluation.internal;

import com.xpn.xwiki.objects.BaseObject;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.evaluation.ObjectEvaluator;
import org.xwiki.evaluation.ObjectEvaluatorException;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component
@Singleton
public class DefaultObjectEvaluator
implements ObjectEvaluator {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> contextComponentManagerProvider;
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> entityReferenceSerializer;

    @Override
    public Map<String, String> evaluate(BaseObject object) throws ObjectEvaluatorException {
        if (object == null) {
            return Collections.emptyMap();
        }
        String xClassName = (String)this.entityReferenceSerializer.serialize((EntityReference)object.getXClassReference(), new Object[0]);
        ComponentManager componentManager = (ComponentManager)this.contextComponentManagerProvider.get();
        if (!componentManager.hasComponent(ObjectEvaluator.class, xClassName)) {
            throw new ObjectEvaluatorException(String.format("Could not find an instance of 'ObjectEvaluator' for XObject of class '%s'.", xClassName));
        }
        try {
            ObjectEvaluator objectEvaluator = (ObjectEvaluator)componentManager.getInstance(ObjectEvaluator.class, xClassName);
            return objectEvaluator.evaluate(object);
        }
        catch (ComponentLookupException e) {
            throw new ObjectEvaluatorException(String.format("Could not instantiate 'ObjectEvaluator' for XObject of class '%s'.", xClassName), e);
        }
    }
}

