/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.pdf.impl.PdfURLFactory;
import com.xpn.xwiki.web.ExternalServletURLFactory;
import com.xpn.xwiki.web.XWikiServletURLFactory;
import com.xpn.xwiki.web.XWikiURLFactory;
import com.xpn.xwiki.web.XWikiURLFactoryService;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XWikiURLFactoryServiceImpl
implements XWikiURLFactoryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiURLFactoryService.class);
    private Map<Integer, Class<? extends XWikiURLFactory>> factoryMap;

    public XWikiURLFactoryServiceImpl(XWiki xwiki) {
        this.init(xwiki);
    }

    private void init(XWiki xwiki) {
        this.factoryMap = new HashMap<Integer, Class<? extends XWikiURLFactory>>();
        this.register(xwiki, 2, ExternalServletURLFactory.class, "xwiki.urlfactory.xmlrpcclass");
        this.register(xwiki, 0, XWikiServletURLFactory.class, "xwiki.urlfactory.servletclass");
        this.register(xwiki, 4, PdfURLFactory.class, "xwiki.urlfactory.pdfclass");
    }

    protected void register(XWiki xwiki, int mode, Class<? extends XWikiURLFactory> defaultImpl, String propertyName) {
        this.factoryMap.put(mode, defaultImpl);
        String urlFactoryClassName = xwiki.Param(propertyName);
        if (urlFactoryClassName != null) {
            try {
                LOGGER.debug("Using custom url factory [" + urlFactoryClassName + "]");
                Class<?> urlFactoryClass = Class.forName(urlFactoryClassName);
                this.factoryMap.put(mode, urlFactoryClass);
            }
            catch (Exception e) {
                LOGGER.error("Failed to load custom url factory class [" + urlFactoryClassName + "]");
            }
        }
    }

    @Override
    public XWikiURLFactory createURLFactory(int mode, XWikiContext context) {
        XWikiURLFactory urlf = null;
        try {
            Class<? extends XWikiURLFactory> urlFactoryClass = this.factoryMap.get(mode);
            urlf = urlFactoryClass.newInstance();
            urlf.init(context);
        }
        catch (Exception e) {
            LOGGER.error("Failed to create url factory", (Throwable)e);
        }
        return urlf;
    }
}

