/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.localization.ContextualLocalizationManager;

@Deprecated
public class XWikiMessageTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiMessageTool.class);
    private static final String KEY = "documentBundles";
    private static final String LOAD_ERROR_MSG_FMT = "Failed to load internationalization document bundle [ %s ].";
    protected ResourceBundle bundle;
    @Deprecated
    protected XWikiContext context;
    private Map<Long, Properties> propsCache = new HashMap<Long, Properties>();
    private Map<Long, Date> previousDates = new HashMap<Long, Date>();
    private Set<Long> docsToRefresh = new HashSet<Long>();
    private ContextualLocalizationManager localization;

    public XWikiMessageTool(ContextualLocalizationManager localization) {
        this.localization = localization;
    }

    public XWikiMessageTool(ResourceBundle bundle, XWikiContext context) {
        this.bundle = bundle;
        this.context = context;
    }

    protected XWikiContext getXWikiContext() {
        return this.context;
    }

    public String get(String key) {
        String translation;
        if (this.localization != null) {
            translation = this.get(key, ArrayUtils.EMPTY_OBJECT_ARRAY);
        } else {
            translation = this.getTranslation(key);
            if (translation == null) {
                try {
                    translation = this.bundle.getString(key);
                }
                catch (Exception e) {
                    translation = key;
                }
            }
        }
        return translation;
    }

    public String get(String key, List<?> params) {
        return this.get(key, params.toArray());
    }

    public String get(String key, Object ... params) {
        String translation;
        if (this.localization != null) {
            translation = this.localization.getTranslationPlain(key, params);
            if (translation == null) {
                translation = key;
            }
        } else {
            translation = this.get(key);
            if (params != null && translation != null) {
                translation = MessageFormat.format(translation, params);
            }
        }
        return translation;
    }

    protected List<String> getDocumentBundleNames() {
        XWikiContext context = this.getXWikiContext();
        if (context == null) {
            return Collections.emptyList();
        }
        String docNames = context.getWiki().getXWikiPreference(KEY, context);
        if (docNames == null || "".equals(docNames)) {
            docNames = context.getWiki().Param("xwiki.documentBundles");
        }
        List<Object> docNamesList = docNames == null ? new ArrayList() : Arrays.asList(docNames.split(","));
        return docNamesList;
    }

    public List<XWikiDocument> getDocumentBundles() {
        XWikiContext context = this.getXWikiContext();
        if (context == null) {
            return Collections.emptyList();
        }
        String defaultLanguage = context.getWiki().getDefaultLanguage(context);
        ArrayList<XWikiDocument> result = new ArrayList<XWikiDocument>();
        for (String docName : this.getDocumentBundleNames()) {
            for (XWikiDocument docBundle : this.getDocumentBundles(docName.trim(), defaultLanguage)) {
                if (docBundle == null) continue;
                if (!docBundle.isNew()) {
                    Long docId = docBundle.getId();
                    Date docDate = docBundle.getDate();
                    if (!docDate.equals(this.previousDates.get(docId))) {
                        this.docsToRefresh.add(docId);
                        this.previousDates.put(docId, docDate);
                    }
                    result.add(docBundle);
                    continue;
                }
                LOGGER.warn("The document [" + docBundle.getFullName() + "] is listed as an internationalization document bundle but it does not exist.");
            }
        }
        return result;
    }

    public XWikiDocument getDocumentBundle(String documentName) {
        XWikiDocument docBundle = null;
        if (!documentName.isEmpty()) {
            try {
                XWikiContext context = this.getXWikiContext();
                if (context != null) {
                    docBundle = context.getWiki().getDocument(documentName, context);
                    docBundle = docBundle.getTranslatedDocument(context);
                }
            }
            catch (XWikiException e) {
                LOGGER.error(String.format(LOAD_ERROR_MSG_FMT, documentName), (Throwable)e);
                docBundle = null;
            }
        }
        return docBundle;
    }

    public List<XWikiDocument> getDocumentBundles(String documentName, String defaultLanguage) {
        ArrayList<XWikiDocument> list = new ArrayList<XWikiDocument>();
        if (documentName.length() != 0) {
            try {
                XWikiContext context = this.getXWikiContext();
                if (context != null) {
                    XWikiDocument defdocBundle;
                    XWikiDocument docBundle = context.getWiki().getDocument(documentName, context);
                    XWikiDocument tdocBundle = docBundle.getTranslatedDocument(context);
                    list.add(tdocBundle);
                    if (!tdocBundle.getRealLanguage().equals(defaultLanguage) && tdocBundle != (defdocBundle = docBundle.getTranslatedDocument(defaultLanguage, context))) {
                        list.add(defdocBundle);
                    }
                }
            }
            catch (XWikiException e) {
                LOGGER.error(String.format(LOAD_ERROR_MSG_FMT, documentName), (Throwable)e);
            }
        }
        return list;
    }

    public Properties getDocumentBundleProperties(XWikiDocument docBundle) {
        Properties props = new Properties();
        String content = docBundle.getContent();
        try {
            props.load(new StringReader(content));
        }
        catch (IOException e) {
            LOGGER.error("Failed to parse content of document [" + String.valueOf(docBundle) + "] as translation content", (Throwable)e);
        }
        return props;
    }

    protected String getTranslation(String key) {
        String returnValue = null;
        if (key != null) {
            for (XWikiDocument docBundle : this.getDocumentBundles()) {
                if (docBundle == null) continue;
                Long docId = docBundle.getId();
                Properties props = null;
                if (this.docsToRefresh.contains(docId) || !this.propsCache.containsKey(docId)) {
                    props = this.getDocumentBundleProperties(docBundle);
                    this.propsCache.put(docId, props);
                    this.docsToRefresh.remove(docId);
                } else {
                    props = this.propsCache.get(docId);
                }
                if ((returnValue = props.getProperty(key)) == null) continue;
                break;
            }
        }
        return returnValue;
    }
}

