/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.plugin.fileupload.FileUploadPlugin;
import com.xpn.xwiki.util.Util;
import com.xpn.xwiki.web.UtilsCompatibilityAspect;
import com.xpn.xwiki.web.XWikiEngineContext;
import com.xpn.xwiki.web.XWikiRequest;
import com.xpn.xwiki.web.XWikiResponse;
import com.xpn.xwiki.web.XWikiServletRequest;
import com.xpn.xwiki.web.XWikiServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.attachment.validation.AttachmentValidationException;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.xml.XMLUtils;

public class Utils {
    protected static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);
    private static final String PLACEHOLDERS_CONTEXT_KEY = Utils.class.getCanonicalName() + "_placeholders";
    private static final String PLACEHOLDERS_ENABLED_CONTEXT_KEY = Utils.class.getCanonicalName() + "_placeholders_enabled";
    private static ComponentManager rootComponentManager;

    public static void parseTemplate(String template, XWikiContext context) throws XWikiException {
        Utils.parseTemplate(template, true, context);
    }

    public static void parseTemplate(String template, boolean write, XWikiContext context) throws XWikiException {
        XWikiResponse response = context.getResponse();
        if (response.getStatus() == 302 || context.isResponseSent()) {
            return;
        }
        response.setContentType("text/html; charset=" + context.getWiki().getEncoding());
        String action = context.getAction();
        long cacheSetting = context.getWiki().getXWikiPreferenceAsLong("headers_nocache", -1L, context);
        if (cacheSetting == -1L) {
            cacheSetting = context.getWiki().ParamAsLong("xwiki.httpheaders.cache", -1L);
        }
        if (cacheSetting == -1L) {
            cacheSetting = 1L;
        }
        if (!"download".equals(action) && !"skin".equals(action) && context.getResponse() instanceof XWikiServletResponse) {
            if (context.getWiki().getXWikiPreferenceAsLong("headers_lastmodified", 0L, context) != 0L && context.getDoc() != null) {
                response.setDateHeader("Last-Modified", context.getDoc().getDate().getTime());
            }
            if (cacheSetting == 1L) {
                response.setHeader("Pragma", "no-cache");
                response.setHeader("Cache-Control", "no-cache");
            } else if (cacheSetting == 2L) {
                response.setHeader("Pragma", "no-cache");
                response.setHeader("Cache-Control", "max-age=0, no-cache, no-store");
            } else if (cacheSetting == 3L) {
                response.setHeader("Cache-Control", "private");
            } else if (cacheSetting == 4L) {
                response.setHeader("Cache-Control", "public");
            }
            long expires = context.getWiki().getXWikiPreferenceAsLong("headers_expires", -1L, context);
            if (expires == -1L) {
                response.setDateHeader("Expires", -1L);
            } else if (expires != 0L) {
                response.setDateHeader("Expires", new Date().getTime() + 2592000000L);
            }
        }
        if (("download".equals(action) || "skin".equals(action)) && (cacheSetting == 1L || cacheSetting == 2L)) {
            response.setHeader("Cache-Control", "no-cache");
        }
        context.getWiki().getPluginManager().beginParsing(context);
        Utils.enablePlaceholders(context);
        String content = "";
        try {
            content = context.getWiki().evaluateTemplate(template + ".vm", context);
            content = Utils.replacePlaceholders(content, context);
            Utils.disablePlaceholders(context);
            content = context.getWiki().getPluginManager().endParsing(content.trim(), context);
        }
        catch (IOException e) {
            LOGGER.debug("IOException while evaluating template [{}] from /templates/", (Object)template, (Object)e);
            try {
                content = context.getWiki().evaluateTemplate("templatedoesnotexist.vm", context);
                content = content.trim();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!context.isFinished()) {
            if (context.getResponse() instanceof XWikiServletResponse) {
                try {
                    response.setContentLength(content.getBytes(context.getWiki().getEncoding()).length);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            if (write && response.getStatus() != 302) {
                try {
                    try {
                        response.getOutputStream().write(content.getBytes(context.getWiki().getEncoding()));
                    }
                    catch (IllegalStateException ex) {
                        response.getWriter().write(content);
                    }
                }
                catch (IOException e) {
                    throw new XWikiException(11, 11011, "Exception while sending response", e);
                }
            }
        }
        try {
            response.getOutputStream().flush();
        }
        catch (Throwable ex) {
            try {
                response.getWriter().flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Deprecated(since="17.0.0RC1")
    public static String getRedirect(XWikiRequest request, String defaultRedirect) {
        String redirect = request.getParameter("xredirect");
        if (StringUtils.isBlank((CharSequence)redirect)) {
            redirect = defaultRedirect;
        }
        return redirect;
    }

    public static String getRedirect(String action, String queryString, XWikiContext context) {
        return Utils.getRedirect(action, queryString, "xredirect");
    }

    public static String getRedirect(String action, String queryString, String ... redirectParameters) {
        String p;
        XWikiContext context = Utils.getContext();
        XWikiRequest request = context.getRequest();
        String redirect = null;
        String[] stringArray = redirectParameters;
        int n = stringArray.length;
        for (int i = 0; i < n && !StringUtils.isNotEmpty((CharSequence)(redirect = request.getParameter(p = stringArray[i]))); ++i) {
        }
        if (StringUtils.isEmpty(redirect)) {
            redirect = context.getDoc().getURL(action, queryString, true, context);
        }
        return redirect;
    }

    public static String getRedirect(String action, XWikiContext context) {
        return Utils.getRedirect(action, null, context);
    }

    @Deprecated(since="17.0.0RC1")
    public static String getPage(XWikiRequest request, String defaultpage) {
        String page = request.getParameter("xpage");
        if (StringUtils.isEmpty((CharSequence)page)) {
            page = defaultpage;
        }
        return page;
    }

    public static String getFileName(List<FileItem> filelist, String name) {
        for (FileItem item : filelist) {
            if (!name.equals(item.getFieldName())) continue;
            return item.getName();
        }
        return null;
    }

    public static byte[] getContent(List<FileItem> filelist, String name) throws XWikiException {
        for (FileItem item : filelist) {
            if (!name.equals(item.getFieldName())) continue;
            byte[] data = new byte[(int)item.getSize()];
            InputStream fileis = null;
            try {
                fileis = item.getInputStream();
                fileis.read(data);
            }
            catch (IOException e) {
                throw new XWikiException(11, 11009, "Exception while reading uploaded parsed file", e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)fileis);
            }
            return data;
        }
        return null;
    }

    @Deprecated(since="17.0.0RC1")
    public static XWikiContext prepareContext(String action, XWikiRequest request, XWikiResponse response, XWikiEngineContext engine_context) throws XWikiException {
        XWikiContext context = new XWikiContext();
        String dbname = "xwiki";
        URL url = XWiki.getRequestURL(request);
        context.setURL(url);
        context.setEngineContext(engine_context);
        context.setRequest(request);
        context.setResponse(response);
        context.setAction(action);
        context.setWikiId(dbname);
        int mode = 0;
        if (request instanceof XWikiServletRequest) {
            mode = 0;
        }
        context.setMode(mode);
        return context;
    }

    public static Map<String, String[]> parseParameters(String data, String encoding) throws UnsupportedEncodingException {
        if (!StringUtils.isEmpty((CharSequence)data)) {
            byte[] bytes = null;
            try {
                bytes = encoding == null ? data.getBytes() : data.getBytes(encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return Utils.parseParameters(bytes, encoding);
        }
        return Collections.emptyMap();
    }

    public static Map<String, String[]> parseParameters(byte[] data, String encoding) throws UnsupportedEncodingException {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        if (data != null && data.length > 0) {
            int ix = 0;
            int ox = 0;
            String key = null;
            String value = null;
            block6: while (ix < data.length) {
                byte c = data[ix++];
                switch ((char)c) {
                    case '&': {
                        value = new String(data, 0, ox, encoding);
                        if (key != null) {
                            Utils.putMapEntry(map, key, value);
                            key = null;
                        }
                        ox = 0;
                        continue block6;
                    }
                    case '=': {
                        if (key == null) {
                            key = new String(data, 0, ox, encoding);
                            ox = 0;
                            continue block6;
                        }
                        data[ox++] = c;
                        continue block6;
                    }
                    case '+': {
                        data[ox++] = 32;
                        continue block6;
                    }
                    case '%': {
                        data[ox++] = (byte)((Utils.convertHexDigit(data[ix++]) << 4) + Utils.convertHexDigit(data[ix++]));
                        continue block6;
                    }
                }
                data[ox++] = c;
            }
            if (key != null) {
                value = new String(data, 0, ox, encoding);
                Utils.putMapEntry(map, key, value);
            }
        }
        return map;
    }

    private static byte convertHexDigit(byte b) {
        if (b >= 48 && b <= 57) {
            return (byte)(b - 48);
        }
        if (b >= 97 && b <= 102) {
            return (byte)(b - 97 + 10);
        }
        if (b >= 65 && b <= 70) {
            return (byte)(b - 65 + 10);
        }
        return 0;
    }

    private static void putMapEntry(Map<String, String[]> map, String name, String value) {
        String[] newValues = null;
        String[] oldValues = map.get(name);
        if (oldValues == null) {
            newValues = new String[]{value};
        } else {
            newValues = new String[oldValues.length + 1];
            System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
            newValues[oldValues.length] = value;
        }
        map.put(name, newValues);
    }

    @Deprecated
    public static String formEncode(String value) {
        return XMLUtils.escape((String)value);
    }

    public static String SQLFilter(String text) {
        try {
            return text.replaceAll("'", "''");
        }
        catch (Exception e) {
            return text;
        }
    }

    @Deprecated
    public static String encode(String text, XWikiContext context) {
        return Util.encodeURI(text, context);
    }

    @Deprecated
    public static String decode(String text, XWikiContext context) {
        return Util.decodeURI(text, context);
    }

    public static FileUploadPlugin handleMultipart(HttpServletRequest request, XWikiContext context) {
        FileUploadPlugin fileupload = null;
        try {
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                fileupload = new FileUploadPlugin("fileupload", "fileupload", context);
                context.put("fileuploadplugin", fileupload);
                fileupload.loadFileList(context);
            }
        }
        catch (AttachmentValidationException e) {
            context.put("exception", (Object)e);
        }
        catch (Exception e) {
            LOGGER.error("Failed to process MultiPart request", (Throwable)e);
        }
        return fileupload;
    }

    public static void setComponentManager(ComponentManager componentManager) {
        rootComponentManager = componentManager;
    }

    @Deprecated
    public static ComponentManager getRootComponentManager() {
        return rootComponentManager;
    }

    @Deprecated
    public static ComponentManager getComponentManager() {
        ComponentManager contextComponentManager;
        try {
            contextComponentManager = (ComponentManager)rootComponentManager.getInstance(ComponentManager.class, "context/root");
        }
        catch (ComponentLookupException e) {
            contextComponentManager = rootComponentManager;
            LOGGER.debug("Failed to find the [context/root] Component Manager. Cause: [{}]. Using the Root Component Manager", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        return contextComponentManager;
    }

    @Deprecated
    public static ComponentManager getContextComponentManager() {
        ComponentManager contextComponentManager;
        try {
            contextComponentManager = (ComponentManager)rootComponentManager.getInstance(ComponentManager.class, "context");
        }
        catch (ComponentLookupException e) {
            contextComponentManager = rootComponentManager;
            LOGGER.debug("Failed to find the [context] Component Manager. Cause: [{}]. Using the Root Component Manager", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        return contextComponentManager;
    }

    @Deprecated
    public static <T> T getComponent(Class<T> role, String hint) {
        return Utils.getComponent(role, hint);
    }

    @Deprecated
    public static <T> T getComponent(Class<T> role) {
        return Utils.getComponent(role);
    }

    @Deprecated
    public static <T> T getComponent(Type roleType, String roleHint) {
        Object component;
        ComponentManager componentManager = Utils.getContextComponentManager();
        if (componentManager != null) {
            try {
                component = componentManager.getInstance(roleType, roleHint);
            }
            catch (ComponentLookupException e) {
                throw new RuntimeException("Failed to load component for type [" + String.valueOf(roleType) + "] for hint [" + roleHint + "]", e);
            }
        } else {
            throw new RuntimeException("Component manager has not been initialized before lookup for [" + String.valueOf(roleType) + "] for hint [" + roleHint + "]");
        }
        return (T)component;
    }

    @Deprecated
    public static <T> T getComponent(Type roleType) {
        return Utils.getComponent(roleType, "default");
    }

    @Deprecated
    public static <T> List<T> getComponentList(Class<T> role) {
        List components;
        ComponentManager componentManager = Utils.getContextComponentManager();
        if (componentManager != null) {
            try {
                components = componentManager.getInstanceList(role);
            }
            catch (ComponentLookupException e) {
                throw new RuntimeException("Failed to load components with role [" + role.getName() + "]", e);
            }
        } else {
            throw new RuntimeException("Component manager has not been initialized before lookup for role [" + role.getName() + "]");
        }
        return components;
    }

    public static XWikiContext getContext() {
        Provider xcontextProvider = (Provider)Utils.getComponent(XWikiContext.TYPE_PROVIDER);
        return xcontextProvider != null ? (XWikiContext)xcontextProvider.get() : null;
    }

    public static boolean arePlaceholdersEnabled(XWikiContext context) {
        Boolean enabled = (Boolean)context.get(PLACEHOLDERS_ENABLED_CONTEXT_KEY);
        return enabled != null && enabled != false;
    }

    public static void enablePlaceholders(XWikiContext context) {
        context.put(PLACEHOLDERS_CONTEXT_KEY, new HashMap());
        context.put(PLACEHOLDERS_ENABLED_CONTEXT_KEY, new Boolean(true));
    }

    public static void disablePlaceholders(XWikiContext context) {
        context.remove(PLACEHOLDERS_CONTEXT_KEY);
        context.remove(PLACEHOLDERS_ENABLED_CONTEXT_KEY);
    }

    public static String createPlaceholder(String value, XWikiContext context) {
        String key;
        if (!Utils.arePlaceholdersEnabled(context)) {
            return value;
        }
        Map renderingKeys = (Map)context.get(PLACEHOLDERS_CONTEXT_KEY);
        while (renderingKeys.containsKey(key = "KEY" + RandomStringUtils.secure().nextAlphanumeric(10) + "KEY")) {
        }
        renderingKeys.put(key, value);
        return key;
    }

    public static String replacePlaceholders(String content, XWikiContext context) {
        if (!Utils.arePlaceholdersEnabled(context)) {
            return content;
        }
        String result = content;
        Map renderingKeys = (Map)context.get(PLACEHOLDERS_CONTEXT_KEY);
        for (Map.Entry e : renderingKeys.entrySet()) {
            result = result.replace((CharSequence)e.getKey(), (CharSequence)e.getValue());
        }
        return result;
    }

    public static Boolean isAjaxRequest(XWikiContext context) {
        return BooleanUtils.isTrue((Boolean)((Boolean)context.get("ajax")));
    }

    public static Object getComponent(String string) {
        return UtilsCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_web_UtilsCompatibilityAspect$com_xpn_xwiki_web_Utils$getComponent(string);
    }

    public static Object getComponent(String string, String string2) {
        return UtilsCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_web_UtilsCompatibilityAspect$com_xpn_xwiki_web_Utils$getComponent(string, string2);
    }
}

