/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.fileupload.FileUploadPlugin;
import com.xpn.xwiki.web.XWikiAction;
import com.xpn.xwiki.web.XWikiResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.attachment.validation.AttachmentValidationException;
import org.xwiki.component.annotation.Component;
import org.xwiki.localization.LocaleUtils;
import org.xwiki.model.reference.DocumentReference;

@Component
@Named(value="upload")
@Singleton
public class UploadAction
extends XWikiAction {
    public static final String FILE_FIELD_NAME = "filepath";
    private static final Logger LOGGER = LoggerFactory.getLogger(UploadAction.class);
    private static final String FILENAME_FIELD_NAME = "filename";

    @Override
    public boolean action(XWikiContext context) throws XWikiException {
        FileUploadPlugin fileupload;
        XWikiResponse response = context.getResponse();
        Object exception = context.get("exception");
        boolean ajax = (Boolean)context.get("ajax");
        if (exception != null && exception instanceof AttachmentValidationException) {
            AttachmentValidationException exp = (AttachmentValidationException)((Object)exception);
            response.setStatus(exp.getHttpStatus());
            this.getCurrentScriptContext().setAttribute("message", exp.getTranslationKey(), 100);
            this.getCurrentScriptContext().setAttribute("parameters", exp.getTranslationParameters(), 100);
            context.put("message", exp.getContextMessage());
            return true;
        }
        if (!this.csrfTokenCheck(context)) {
            return false;
        }
        XWikiDocument doc = context.getDoc().clone();
        if (doc.isNew()) {
            doc.setLocale(Locale.ROOT);
            if (doc.getDefaultLocale() == Locale.ROOT) {
                doc.setDefaultLocale(LocaleUtils.toLocale((String)context.getWiki().getLanguagePreference(context), (Locale)Locale.ROOT));
            }
        }
        if ((fileupload = (FileUploadPlugin)context.get("fileuploadplugin")) == null) {
            this.getCurrentScriptContext().setAttribute("message", "core.action.upload.failure.noFiles", 100);
            return true;
        }
        LinkedHashMap<String, String> fileNames = new LinkedHashMap<String, String>();
        ArrayList<String> wrongFileNames = new ArrayList<String>();
        LinkedHashMap<String, String> failedFiles = new LinkedHashMap<String, String>();
        for (String string : fileupload.getFileItemNames(context)) {
            try {
                String fileName;
                if (!string.startsWith(FILE_FIELD_NAME) || (fileName = this.getFileName(string, fileupload, context)) == null) continue;
                fileNames.put(fileName, string);
            }
            catch (Exception ex) {
                wrongFileNames.add(fileupload.getFileName(string, context));
            }
        }
        for (Map.Entry entry : fileNames.entrySet()) {
            try {
                this.uploadAttachment((String)entry.getValue(), (String)entry.getKey(), fileupload, doc, context);
            }
            catch (Exception ex) {
                LOGGER.warn("Saving uploaded file failed", (Throwable)ex);
                failedFiles.put((String)entry.getKey(), ExceptionUtils.getRootCauseMessage((Throwable)ex));
            }
        }
        LOGGER.debug("Found files to upload: " + String.valueOf(fileNames));
        LOGGER.debug("Failed attachments: " + String.valueOf(failedFiles));
        LOGGER.debug("Wrong attachment names: " + String.valueOf(wrongFileNames));
        if (ajax) {
            try {
                response.getOutputStream().println("ok");
            }
            catch (IOException ex) {
                LOGGER.error("Unhandled exception writing output:", (Throwable)ex);
            }
            return false;
        }
        if (failedFiles.size() > 0 || !wrongFileNames.isEmpty()) {
            this.getCurrentScriptContext().setAttribute("message", "core.action.upload.failure", 100);
            this.getCurrentScriptContext().setAttribute("failedFiles", failedFiles, 100);
            this.getCurrentScriptContext().setAttribute("wrongFileNames", wrongFileNames, 100);
            return true;
        }
        String redirect = fileupload.getFileItemAsString("xredirect", context);
        if (StringUtils.isEmpty((CharSequence)redirect)) {
            redirect = context.getDoc().getURL("attach", true, context);
        }
        this.sendRedirect(response, redirect);
        return false;
    }

    public boolean uploadAttachment(String fieldName, String filename, FileUploadPlugin fileupload, XWikiDocument doc, XWikiContext context) throws XWikiException {
        XWikiAttachment attachment;
        XWikiResponse response = context.getResponse();
        DocumentReference usernameReference = context.getUserReference();
        try {
            InputStream contentInputStream = fileupload.getFileItemInputStream(fieldName, context);
            attachment = doc.setAttachment(filename, contentInputStream, context);
        }
        catch (IOException e) {
            throw new XWikiException(11, 11009, "Exception while reading uploaded parsed file", e);
        }
        doc.setAuthorReference(usernameReference);
        if (doc.isNew()) {
            doc.setCreatorReference(usernameReference);
        }
        attachment.resetMimeType(context);
        attachment.setCharset(context.getRequest().getCharacterEncoding());
        String attachmentComment = StringUtils.defaultString((String)context.getRequest().getParameter("comment"));
        attachment.setComment(attachmentComment);
        ArrayList<String> params = new ArrayList<String>();
        params.add(filename);
        String nextRev = attachment.getNextVersion();
        if (StringUtils.isBlank((CharSequence)attachmentComment)) {
            params.add(nextRev);
        } else {
            params.add(String.format("%s (%s)", nextRev, attachmentComment));
        }
        String documentComment = attachment.isImage(context) ? this.localizePlainOrReturnKey("core.comment.uploadImageComment", params.toArray()) : this.localizePlainOrReturnKey("core.comment.uploadAttachmentComment", params.toArray());
        context.getWiki().checkSavingDocument(context.getUserReference(), doc, documentComment, true, context);
        try {
            context.getWiki().saveDocument(doc, documentComment, context);
        }
        catch (XWikiException e) {
            if (e.getCode() == 11014) {
                response.setStatus(500);
                context.put("message", "javaheapspace");
                return true;
            }
            throw e;
        }
        return false;
    }

    protected String getFileName(String fieldName, FileUploadPlugin fileupload, XWikiContext context) throws XWikiException {
        String filenameField = FILENAME_FIELD_NAME + fieldName.substring(FILE_FIELD_NAME.length());
        String filename = null;
        filename = fileupload.getFileItemAsString(filenameField, context);
        if (!(StringUtils.isBlank((CharSequence)filename) || filename.indexOf("/") == -1 && filename.indexOf("\\") == -1 && filename.indexOf(";") == -1)) {
            throw new XWikiException(11, 11006, "Invalid filename: " + filename);
        }
        if (StringUtils.isBlank((CharSequence)filename)) {
            String fname = fileupload.getFileName(fieldName, context);
            if (StringUtils.indexOf((CharSequence)fname, (CharSequence)"/") >= 0) {
                fname = StringUtils.substringAfterLast((String)fname, (String)"/");
            }
            if (StringUtils.indexOf((CharSequence)fname, (CharSequence)"\\") >= 0) {
                fname = StringUtils.substringAfterLast((String)fname, (String)"\\");
            }
            filename = fname;
        }
        if (StringUtils.isBlank((CharSequence)(filename = filename.replaceAll("\\+", " ")))) {
            return null;
        }
        return filename;
    }

    @Override
    public String render(XWikiContext context) throws XWikiException {
        boolean ajax = (Boolean)context.get("ajax");
        if (ajax) {
            try {
                context.getResponse().getOutputStream().println("error: " + this.localizePlainOrKey((String)context.get("message"), new Object[0]));
            }
            catch (IOException ex) {
                LOGGER.error("Unhandled exception writing output:", (Throwable)ex);
            }
            return null;
        }
        this.getCurrentScriptContext().setAttribute("viewer", "uploadfailure", 100);
        return "view";
    }
}

